/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.spell.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.fife.ui.rsyntaxtextarea.ErrorStrip;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.spell.SpellingParser;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class DemoRootPane
extends JRootPane
implements HyperlinkListener,
SyntaxConstants {
    private RTextScrollPane scrollPane;
    private RSyntaxTextArea textArea = this.createTextArea();
    private SpellingParser parser;
    private ToggleSpellCheckingAction toggleAction;
    private static final String INPUT_FILE = "Input.java";

    public DemoRootPane() {
        this.scrollPane = new RTextScrollPane((RTextArea)this.textArea, true);
        ErrorStrip errorStrip = new ErrorStrip(this.textArea);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.scrollPane);
        jPanel.add((Component)errorStrip, "After");
        this.getContentPane().add(jPanel);
        this.setJMenuBar(this.createMenuBar());
    }

    public void addNotify() {
        super.addNotify();
        new Thread(){

            public void run() {
                DemoRootPane.this.parser = DemoRootPane.this.createSpellingParser();
                if (DemoRootPane.this.parser != null) {
                    try {
                        File file = File.createTempFile("spellDemo", ".txt");
                        DemoRootPane.this.parser.setUserDictionary(file);
                        System.out.println("User dictionary: " + file.getAbsolutePath());
                    }
                    catch (IOException iOException) {
                        System.err.println("Can't open user dictionary: " + iOException.getMessage());
                    }
                    catch (SecurityException securityException) {
                        System.err.println("Can't open user dictionary: " + securityException.getMessage());
                    }
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            DemoRootPane.access$300(1.access$200(this.this$1)).addParser((Parser)DemoRootPane.access$000(1.access$200(this.this$1)));
                            DemoRootPane.access$400(1.access$200(this.this$1)).setEnabled(true);
                        }
                    });
                }
            }

            static /* synthetic */ DemoRootPane access$200(1 var0) {
                return var0.DemoRootPane.this;
            }
        }.start();
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Options");
        this.toggleAction = new ToggleSpellCheckingAction();
        this.toggleAction.setEnabled(false);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.toggleAction);
        jCheckBoxMenuItem.setSelected(true);
        jMenu.add(jCheckBoxMenuItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem(new AboutAction());
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        return jMenuBar;
    }

    private SpellingParser createSpellingParser() {
        File file = new File("distfiles/english_dic.zip");
        try {
            return SpellingParser.createEnglishSpellingParser(file, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private RSyntaxTextArea createTextArea() {
        RSyntaxTextArea rSyntaxTextArea = new RSyntaxTextArea(25, 70);
        rSyntaxTextArea.setSyntaxEditingStyle("text/java");
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(INPUT_FILE);
        try {
            BufferedReader bufferedReader = null;
            bufferedReader = inputStream != null ? new BufferedReader(new InputStreamReader(inputStream)) : new BufferedReader(new FileReader(INPUT_FILE));
            rSyntaxTextArea.read((Reader)bufferedReader, null);
            bufferedReader.close();
        }
        catch (IOException iOException) {
            rSyntaxTextArea.setText("// Type Java source.  Comments are spell checked.");
        }
        rSyntaxTextArea.setCaretPosition(0);
        rSyntaxTextArea.addHyperlinkListener((HyperlinkListener)this);
        rSyntaxTextArea.requestFocusInWindow();
        rSyntaxTextArea.setMarkOccurrences(true);
        return rSyntaxTextArea;
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL uRL = hyperlinkEvent.getURL();
            if (uRL == null) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
            } else {
                JOptionPane.showMessageDialog(this, "URL clicked:\n" + uRL.toString());
            }
        }
    }

    static /* synthetic */ ToggleSpellCheckingAction access$400(DemoRootPane demoRootPane) {
        return demoRootPane.toggleAction;
    }

    private class ToggleSpellCheckingAction
    extends AbstractAction {
        private boolean enabled;

        public ToggleSpellCheckingAction() {
            this.putValue("Name", "Toggle Spell Checking");
            this.enabled = true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = this.enabled = !this.enabled;
            if (this.enabled) {
                DemoRootPane.this.textArea.addParser((Parser)DemoRootPane.this.parser);
            } else {
                DemoRootPane.this.textArea.removeParser((Parser)DemoRootPane.this.parser);
            }
        }
    }

    private class AboutAction
    extends AbstractAction {
        public AboutAction() {
            this.putValue("Name", "About Spell Checker...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JOptionPane.showMessageDialog(DemoRootPane.this, "<html><b>Spell Checker</b> - An add-on for RSyntaxTextArea<br>that does spell checking in code comments.<br>Version 1.4<br>Licensed under the LGPL", "About Spell Checker", 1);
        }
    }
}

