/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.spell;

import java.awt.Color;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.zip.ZipFile;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.fife.com.swabunga.spell.engine.SpellDictionary;
import org.fife.com.swabunga.spell.engine.SpellDictionaryHashMap;
import org.fife.com.swabunga.spell.engine.Word;
import org.fife.com.swabunga.spell.event.DocumentWordTokenizer;
import org.fife.com.swabunga.spell.event.SpellCheckEvent;
import org.fife.com.swabunga.spell.event.SpellCheckListener;
import org.fife.com.swabunga.spell.event.SpellChecker;
import org.fife.com.swabunga.spell.event.StringWordTokenizer;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.parser.AbstractParser;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParseResult;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ExtendedHyperlinkListener;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.fife.ui.rsyntaxtextarea.spell.event.SpellingParserEvent;
import org.fife.ui.rsyntaxtextarea.spell.event.SpellingParserListener;

public class SpellingParser
extends AbstractParser
implements SpellCheckListener,
ExtendedHyperlinkListener {
    private DefaultParseResult result = new DefaultParseResult((Parser)this);
    private SpellChecker sc;
    private RSyntaxDocument doc;
    private int startOffs;
    private int errorCount;
    private int maxErrorCount;
    private boolean allowAdd;
    private boolean allowIgnore;
    private Color squiggleUnderlineColor;
    private String noticePrefix;
    private String noticeSuffix;
    private EventListenerList listenerList;
    private File dictionaryFile;
    private static final String MSG = "org.fife.ui.rsyntaxtextarea.spell.SpellingParser";
    private static final ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.rsyntaxtextarea.spell.SpellingParser");
    private static final String ADD = "add";
    private static final String IGNORE = "ignore";
    private static final String REPLACE = "replace";
    private static final String TOOLTIP_TEXT_FORMAT = "<html><img src='lightbulb.png' width='16' height='16'>{0}<hr><img src='spellcheck.png' width='16' height='16'>{1}<br>{2}<br>&nbsp;";
    private static final int DEFAULT_MAX_ERROR_COUNT = 100;

    public SpellingParser(SpellDictionary spellDictionary) {
        this.sc = new SpellChecker(spellDictionary);
        this.sc.addSpellCheckListener(this);
        this.setSquiggleUnderlineColor(Color.BLUE);
        this.setHyperlinkListener(this);
        this.setMaxErrorCount(100);
        this.setAllowAdd(true);
        this.setAllowIgnore(true);
        String string = msg.getString("IncorrectSpelling");
        int n = string.indexOf("{0}");
        this.noticePrefix = string.substring(0, n);
        this.noticeSuffix = string.substring(n + 3);
        this.listenerList = new EventListenerList();
    }

    public void addSpellingParserListener(SpellingParserListener spellingParserListener) {
        this.listenerList.add(SpellingParserListener.class, spellingParserListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpellingParser createEnglishSpellingParser(File file, boolean bl) throws IOException {
        SpellDictionaryHashMap spellDictionaryHashMap = null;
        ZipFile zipFile = new ZipFile(file);
        try {
            InputStream inputStream = zipFile.getInputStream(zipFile.getEntry("eng_com.dic"));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                spellDictionaryHashMap = new SpellDictionaryHashMap(bufferedReader);
            }
            finally {
                bufferedReader.close();
            }
            String[] stringArray = null;
            stringArray = bl ? new String[]{"color", "labeled", "center", "ize", "yze"} : new String[]{"colour", "labelled", "centre", "ise", "yse"};
            for (int i = 0; i < stringArray.length; ++i) {
                inputStream = zipFile.getInputStream(zipFile.getEntry(stringArray[i] + ".dic"));
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                try {
                    spellDictionaryHashMap.addDictionary(bufferedReader);
                    continue;
                }
                finally {
                    bufferedReader.close();
                }
            }
        }
        finally {
            zipFile.close();
        }
        return new SpellingParser(spellDictionaryHashMap);
    }

    protected void fireSpellingParserEvent(SpellingParserEvent spellingParserEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$org$fife$ui$rsyntaxtextarea$spell$event$SpellingParserListener == null ? SpellingParser.class$("org.fife.ui.rsyntaxtextarea.spell.event.SpellingParserListener") : class$org$fife$ui$rsyntaxtextarea$spell$event$SpellingParserListener)) continue;
            ((SpellingParserListener)objectArray[i + 1]).spellingParserEvent(spellingParserEvent);
        }
    }

    public boolean getAllowAdd() {
        return this.allowAdd;
    }

    public boolean getAllowIgnore() {
        return this.allowIgnore;
    }

    public URL getImageBase() {
        return this.getClass().getResource("/org/fife/ui/rsyntaxtextarea/spell/");
    }

    private final int getLineOfOffset(int n) {
        return this.doc.getDefaultRootElement().getElementIndex(n);
    }

    public int getMaxErrorCount() {
        return this.maxErrorCount;
    }

    public Color getSquiggleUnderlineColor() {
        return this.squiggleUnderlineColor;
    }

    public File getUserDictionary() {
        return this.dictionaryFile;
    }

    public void linkClicked(RSyntaxTextArea rSyntaxTextArea, HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String string = hyperlinkEvent.getDescription();
            int n = string.indexOf("://");
            String string2 = string.substring(0, n);
            String[] stringArray = string.substring(n + 3).split(",");
            if (REPLACE.equals(string2)) {
                int n2 = Integer.parseInt(stringArray[0]);
                int n3 = Integer.parseInt(stringArray[1]);
                String string3 = stringArray[2];
                rSyntaxTextArea.replaceRange(string3, n2, n2 + n3);
                rSyntaxTextArea.setSelectionStart(n2);
                rSyntaxTextArea.setSelectionEnd(n2 + string3.length());
            } else if (ADD.equals(string2)) {
                String string4;
                if (this.dictionaryFile == null) {
                    UIManager.getLookAndFeel().provideErrorFeedback((Component)rSyntaxTextArea);
                }
                if (this.sc.addToDictionary(string4 = stringArray[0])) {
                    rSyntaxTextArea.forceReparsing((Parser)this);
                    SpellingParserEvent spellingParserEvent = new SpellingParserEvent(this, rSyntaxTextArea, 0, string4);
                    this.fireSpellingParserEvent(spellingParserEvent);
                } else {
                    UIManager.getLookAndFeel().provideErrorFeedback((Component)rSyntaxTextArea);
                }
            } else if (IGNORE.equals(string2)) {
                String string5 = stringArray[0];
                this.sc.ignoreAll(string5);
                rSyntaxTextArea.forceReparsing((Parser)this);
                SpellingParserEvent spellingParserEvent = new SpellingParserEvent(this, rSyntaxTextArea, 1, string5);
                this.fireSpellingParserEvent(spellingParserEvent);
            }
        }
    }

    public ParseResult parse(RSyntaxDocument rSyntaxDocument, String string) {
        Element element = rSyntaxDocument.getDefaultRootElement();
        int n = element.getElementCount();
        this.result.clearNotices();
        this.result.setParsedLines(0, n - 1);
        this.doc = rSyntaxDocument;
        this.errorCount = 0;
        if (string == null || "text/plain".equals(string)) {
            this.startOffs = 0;
            this.parseEntireDocument(rSyntaxDocument);
        } else {
            block0: for (int i = 0; i < n; ++i) {
                for (Token token = rSyntaxDocument.getTokenListForLine(i); token != null && token.isPaintable(); token = token.getNextToken()) {
                    if (!token.isComment()) continue;
                    this.startOffs = token.offset;
                    StringWordTokenizer stringWordTokenizer = new StringWordTokenizer(token.getLexeme());
                    int n2 = this.sc.checkSpelling(stringWordTokenizer);
                    if (n2 == -2) break block0;
                }
            }
        }
        return this.result;
    }

    private void parseEntireDocument(RSyntaxDocument rSyntaxDocument) {
        DocumentWordTokenizer documentWordTokenizer = new DocumentWordTokenizer((Document)rSyntaxDocument);
        this.sc.checkSpelling(documentWordTokenizer);
    }

    public void removeSpellingParserListener(SpellingParserListener spellingParserListener) {
        this.listenerList.remove(SpellingParserListener.class, spellingParserListener);
    }

    public void setAllowAdd(boolean bl) {
        this.allowAdd = bl;
    }

    public void setAllowIgnore(boolean bl) {
        this.allowIgnore = bl;
    }

    public void setMaxErrorCount(int n) {
        this.maxErrorCount = n;
    }

    public void setSquiggleUnderlineColor(Color color) {
        this.squiggleUnderlineColor = color;
    }

    public void setUserDictionary(File file) throws IOException {
        SpellDictionaryHashMap spellDictionaryHashMap = null;
        if (file != null) {
            if (!file.exists()) {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.close();
            }
            spellDictionaryHashMap = new SpellDictionaryHashMap(file);
        } else {
            spellDictionaryHashMap = new SpellDictionaryHashMap();
        }
        this.sc.setUserDictionary(spellDictionaryHashMap);
        this.dictionaryFile = file;
    }

    public void spellingError(SpellCheckEvent spellCheckEvent) {
        String string = spellCheckEvent.getInvalidWord();
        int n = this.startOffs + spellCheckEvent.getWordContextPosition();
        int n2 = this.getLineOfOffset(n);
        String string2 = this.noticePrefix + string + this.noticeSuffix;
        SpellingParserNotice spellingParserNotice = new SpellingParserNotice(this, string2, n2, n, string, this.sc);
        this.result.addNotice((ParserNotice)spellingParserNotice);
        if (++this.errorCount >= this.maxErrorCount) {
            System.out.println("Cancelling the spelling check!");
            spellCheckEvent.cancel();
        }
    }

    private static class SpellingParserNotice
    extends DefaultParserNotice {
        private String word;
        private SpellChecker sc;

        public SpellingParserNotice(SpellingParser spellingParser, String string, int n, int n2, String string2, SpellChecker spellChecker) {
            super((Parser)spellingParser, string, n, n2, string2.length());
            this.setLevel(2);
            this.word = string2;
            this.sc = spellChecker;
        }

        public Color getColor() {
            return ((SpellingParser)this.getParser()).getSquiggleUnderlineColor();
        }

        public String getToolTipText() {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            String string = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
            int n = this.sc.getConfiguration().getInteger("SPELL_THRESHOLD");
            List list = this.sc.getSuggestions(this.word, n);
            if (list == null || list.size() == 0) {
                stringBuffer.append(string).append("&#8226;&nbsp;<em>");
                stringBuffer.append(msg.getString("None"));
                stringBuffer.append("</em><br><br>");
            } else {
                stringBuffer.append("<center>");
                stringBuffer.append("<table width='75%'>");
                for (int i = 0; i < list.size(); ++i) {
                    if (i % 2 == 0) {
                        stringBuffer.append("<tr>");
                    }
                    stringBuffer.append("<td>&#8226;&nbsp;");
                    object = (Word)list.get(i);
                    stringBuffer.append("<a href='").append(SpellingParser.REPLACE).append("://").append(this.getOffset()).append(',').append(this.getLength()).append(',').append(((Word)object).getWord()).append("'>").append(((Word)object).getWord()).append("</a>").append("</td>");
                    if ((i & 1) != 1) continue;
                    stringBuffer.append("</tr>");
                }
                if (list.size() % 2 == 0) {
                    stringBuffer.append("<td></td></tr>");
                }
                stringBuffer.append("</table>");
                stringBuffer.append("</center>");
            }
            SpellingParser spellingParser = (SpellingParser)this.getParser();
            if (spellingParser.getAllowAdd()) {
                stringBuffer.append("<img src='add.png' width='16' height='16'>&nbsp;").append("<a href='").append(SpellingParser.ADD).append("://").append(this.word).append("'>").append(msg.getString("ErrorToolTip.AddToDictionary")).append("</a><br>");
            }
            if (spellingParser.getAllowIgnore()) {
                object = msg.getString("ErrorToolTip.IgnoreWord");
                object = MessageFormat.format((String)object, this.word);
                stringBuffer.append("<img src='cross.png' width='16' height='16'>&nbsp;").append("<a href='").append(SpellingParser.IGNORE).append("://").append(this.word).append("'>").append((String)object).append("</a>");
            }
            object = MessageFormat.format(msg.getString("ErrorToolTip.DescHtml"), this.word);
            String string2 = MessageFormat.format(SpellingParser.TOOLTIP_TEXT_FORMAT, object, msg.getString("ErrorToolTip.SuggestionsHtml"), stringBuffer.toString());
            return string2;
        }

        public String toString() {
            return "[SpellingParserNotice: " + this.word + "]";
        }
    }
}

