/*
 * Decompiled with CFR 0.152.
 */
package org.fife.com.swabunga.spell.event;

import org.fife.com.swabunga.spell.event.AbstractWordFinder;
import org.fife.com.swabunga.spell.event.SpellChecker;
import org.fife.com.swabunga.spell.event.Word;
import org.fife.com.swabunga.spell.event.WordNotFoundException;

public class DefaultWordFinder
extends AbstractWordFinder {
    public DefaultWordFinder(String string) {
        super(string);
    }

    public DefaultWordFinder() {
    }

    public Word next() {
        if (this.nextWord == null) {
            throw new WordNotFoundException("No more words found.");
        }
        this.currentWord.copy(this.nextWord);
        this.setSentenceIterator(this.currentWord);
        boolean bl = false;
        for (int i = this.currentWord.getEnd(); i < this.text.length() && !bl; ++i) {
            if (!this.isWordChar(i)) continue;
            this.nextWord.setStart(i);
            int n = this.getNextWordEnd(this.text, i);
            this.nextWord.setText(this.text.substring(i, n));
            bl = true;
        }
        if (!bl) {
            this.nextWord = null;
        }
        return this.currentWord;
    }

    private int getNextWordEnd(String string, int n) {
        if (SpellChecker.beginsAsINETWord(string.substring(n))) {
            for (int i = n; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isLetterOrDigit(c)) continue;
                if (c == '\r' || c == '\n') {
                    return i;
                }
                if (!Character.isSpaceChar(c)) continue;
                if (i > 0 && Character.isLetterOrDigit(string.charAt(i - 1))) {
                    return i;
                }
                return i - 1;
            }
            return string.length();
        }
        for (int i = n; i < string.length(); ++i) {
            if (this.isWordChar(i)) continue;
            return i;
        }
        return string.length();
    }
}

