/*
 * Decompiled with CFR 0.152.
 */
package org.fife.com.swabunga.spell.engine;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.fife.com.swabunga.spell.engine.Configuration;

public class PropertyConfiguration
extends Configuration {
    public Properties prop = new Properties();
    public URL filename;

    public PropertyConfiguration() {
        try {
            this.filename = this.getClass().getClassLoader().getResource("org/fife/com/swabunga/spell/engine/configuration.properties");
            InputStream inputStream = this.filename.openStream();
            this.prop.load(inputStream);
        }
        catch (Exception exception) {
            System.err.println("Could not load Properties file :");
            exception.printStackTrace();
        }
    }

    public boolean getBoolean(String string) {
        return new Boolean(this.prop.getProperty(string));
    }

    public int getInteger(String string) {
        return new Integer(this.prop.getProperty(string));
    }

    public void setBoolean(String string, boolean bl) {
        String string2 = null;
        string2 = bl ? "true" : "false";
        this.prop.setProperty(string, string2);
        this.save();
    }

    public void setInteger(String string, int n) {
        this.prop.setProperty(string, Integer.toString(n));
        this.save();
    }

    public void save() {
        try {
            File file = new File(this.filename.getFile());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.prop.store(fileOutputStream, "HEADER");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

