/*
 * Decompiled with CFR 0.152.
 */
package org.fife.com.swabunga.spell.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Vector;
import org.fife.com.swabunga.spell.engine.Transformator;
import org.fife.com.swabunga.util.StringUtility;

public class GenericTransformator
implements Transformator {
    private static final char[] defaultEnglishAlphabet = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    public static final char ALPHABET_START = '[';
    public static final char ALPHABET_END = ']';
    public static final String KEYWORD_ALPHBET = "alphabet";
    public static final String[] IGNORED_KEYWORDS = new String[]{"version", "followup", "collapse_result"};
    public static final char STARTMULTI = '(';
    public static final char ENDMULTI = ')';
    public static final String DIGITCODE = "0";
    public static final String REPLACEVOID = "_";
    private Object[] ruleArray = null;
    private char[] alphabetString = defaultEnglishAlphabet;

    public GenericTransformator(File file) throws IOException {
        this.buildRules(new BufferedReader(new FileReader(file)));
        this.alphabetString = this.washAlphabetIntoReplaceList(this.getReplaceList());
    }

    public GenericTransformator(File file, String string) throws IOException {
        this.buildRules(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string)));
        this.alphabetString = this.washAlphabetIntoReplaceList(this.getReplaceList());
    }

    public GenericTransformator(Reader reader) throws IOException {
        this.buildRules(new BufferedReader(reader));
        this.alphabetString = this.washAlphabetIntoReplaceList(this.getReplaceList());
    }

    private char[] washAlphabetIntoReplaceList(char[] cArray) {
        Object object;
        HashMap<String, Character> hashMap = new HashMap<String, Character>(cArray.length);
        for (int i = 0; i < cArray.length; ++i) {
            object = String.valueOf(cArray[i]);
            String string = this.transform((String)object);
            if (hashMap.containsKey(string)) continue;
            hashMap.put(string, new Character(cArray[i]));
        }
        Object[] objectArray = hashMap.values().toArray();
        object = new char[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            object[i] = ((Character)objectArray[i]).charValue();
        }
        return object;
    }

    public char[] getCodeReplaceList() {
        int n;
        Vector<String> vector = new Vector<String>();
        if (this.ruleArray == null) {
            return null;
        }
        for (n = 0; n < this.ruleArray.length; ++n) {
            TransformationRule transformationRule = (TransformationRule)this.ruleArray[n];
            if (transformationRule.getReplaceExp().length() != 1) continue;
            vector.addElement(transformationRule.getReplaceExp());
        }
        char[] cArray = new char[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            cArray[n] = ((String)vector.elementAt(n)).charAt(0);
        }
        return cArray;
    }

    public char[] getReplaceList() {
        return this.alphabetString;
    }

    public String transform(String string) {
        if (this.ruleArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.toUpperCase());
        int n = stringBuffer.length();
        int n2 = 0;
        int n3 = 1;
        while (n2 < n) {
            n3 = 1;
            if (Character.isDigit(stringBuffer.charAt(n2))) {
                StringUtility.replace(stringBuffer, n2, n2 + DIGITCODE.length(), DIGITCODE);
                n2 += n3;
                continue;
            }
            for (int i = 0; i < this.ruleArray.length; ++i) {
                TransformationRule transformationRule = (TransformationRule)this.ruleArray[i];
                if (transformationRule.startsWithExp() && n2 > 0 || n2 + transformationRule.lengthOfMatch() > n || !transformationRule.isMatching(stringBuffer, n2)) continue;
                String string2 = transformationRule.getReplaceExp();
                n3 = string2.length();
                StringUtility.replace(stringBuffer, n2, n2 + transformationRule.getTakeOut(), string2);
                n -= transformationRule.getTakeOut();
                n += n3;
                break;
            }
            n2 += n3;
        }
        return stringBuffer.toString();
    }

    private void buildRules(BufferedReader bufferedReader) throws IOException {
        String string = null;
        Vector vector = new Vector();
        while ((string = bufferedReader.readLine()) != null) {
            this.buildRule(this.realTrimmer(string), vector);
        }
        this.ruleArray = new TransformationRule[vector.size()];
        vector.copyInto(this.ruleArray);
    }

    private void buildRule(String string, Vector vector) {
        int n;
        if (string.length() < 1) {
            return;
        }
        for (n = 0; n < IGNORED_KEYWORDS.length; ++n) {
            if (!string.startsWith(IGNORED_KEYWORDS[n])) continue;
            return;
        }
        if (string.startsWith(KEYWORD_ALPHBET)) {
            n = string.indexOf(91);
            int n2 = string.lastIndexOf(93);
            if (n2 != -1 && n != -1) {
                this.alphabetString = string.substring(++n, n2).toCharArray();
            }
            return;
        }
        TransformationRule transformationRule = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 0;
        int n4 = 0;
        boolean bl3 = true;
        boolean bl4 = false;
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) {
                bl3 = false;
                continue;
            }
            if (bl3) {
                if (!this.isReservedChar(string.charAt(i))) {
                    stringBuffer.append(string.charAt(i));
                    if (!bl4) {
                        ++n3;
                        ++n4;
                    }
                    if (string.charAt(i) == '(' || string.charAt(i) == ')') {
                        boolean bl5 = bl4 = !bl4;
                    }
                }
                if (string.charAt(i) == '-') {
                    --n3;
                }
                if (string.charAt(i) == '^') {
                    bl = true;
                }
                if (string.charAt(i) != '$') continue;
                bl2 = true;
                continue;
            }
            stringBuffer2.append(string.charAt(i));
        }
        if (stringBuffer2.toString().equals(REPLACEVOID)) {
            stringBuffer2 = new StringBuffer("");
        }
        transformationRule = new TransformationRule(stringBuffer.toString(), stringBuffer2.toString(), n3, n4, bl, bl2);
        vector.addElement(transformationRule);
    }

    private boolean isReservedChar(char c) {
        return c == '<' || c == '>' || c == '^' || c == '$' || c == '-' || Character.isDigit(c);
    }

    private String realTrimmer(String string) {
        int n = string.indexOf(35);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string.trim();
    }

    private static class TransformationRule {
        private String replace;
        private char[] match;
        private int takeOut;
        private int matchLength;
        private boolean start;
        private boolean end;

        public TransformationRule(String string, String string2, int n, int n2, boolean bl, boolean bl2) {
            this.match = string.toCharArray();
            this.replace = string2;
            this.takeOut = n;
            this.matchLength = n2;
            this.start = bl;
            this.end = bl2;
        }

        public boolean isMatching(StringBuffer stringBuffer, int n) {
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < this.match.length; ++i) {
                char c = this.match[i];
                if (c == '(' || c == ')') {
                    boolean bl4 = bl2 = !bl2;
                    if (!bl2) {
                        bl &= bl3;
                        continue;
                    }
                    bl3 = false;
                    continue;
                }
                if (c != stringBuffer.charAt(n)) {
                    if (bl2) {
                        bl3 |= false;
                    } else {
                        bl = false;
                    }
                } else if (bl2) {
                    bl3 |= true;
                } else {
                    bl = true;
                }
                if (!bl2) {
                    ++n;
                }
                if (!bl) break;
            }
            if (this.end && n != stringBuffer.length()) {
                bl = false;
            }
            return bl;
        }

        public String getReplaceExp() {
            return this.replace;
        }

        public int getTakeOut() {
            return this.takeOut;
        }

        public boolean startsWithExp() {
            return this.start;
        }

        public int lengthOfMatch() {
            return this.matchLength;
        }

        public String toString() {
            return "Match:" + String.valueOf(this.match) + " Replace:" + this.replace + " TakeOut:" + this.takeOut + " MatchLength:" + this.matchLength + " Start:" + this.start + " End:" + this.end;
        }
    }
}

