/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import java.net.URI;

public class Util {
    private static boolean desktopCreationAttempted;
    private static Object desktop;
    private static final Object LOCK_DESKTOP_CREATION;

    public static boolean browse(URI uRI) {
        Object object;
        boolean bl = false;
        if (uRI != null && (object = Util.getDesktop()) != null) {
            try {
                Method method = object.getClass().getDeclaredMethod("browse", URI.class);
                method.invoke(object, uRI);
                bl = true;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getDesktop() {
        Object object = LOCK_DESKTOP_CREATION;
        synchronized (object) {
            if (!desktopCreationAttempted) {
                desktopCreationAttempted = true;
                try {
                    Class<?> clazz = Class.forName("java.awt.Desktop");
                    Method method = clazz.getDeclaredMethod("isDesktopSupported", null);
                    boolean bl = (Boolean)method.invoke(null, null);
                    if (bl) {
                        method = clazz.getDeclaredMethod("getDesktop", null);
                        desktop = method.invoke(null, null);
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return desktop;
    }

    public static String getHexString(Color color) {
        if (color == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("#");
        int n = color.getRed();
        if (n < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toHexString(n));
        int n2 = color.getGreen();
        if (n2 < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toHexString(n2));
        int n3 = color.getBlue();
        if (n3 < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toHexString(n3));
        return stringBuffer.toString();
    }

    public static Rectangle getScreenBoundsForPoint(int n, int n2) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            GraphicsConfiguration graphicsConfiguration = graphicsDeviceArray[i].getDefaultConfiguration();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            if (!rectangle.contains(n, n2)) continue;
            return rectangle;
        }
        return graphicsEnvironment.getMaximumWindowBounds();
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        int n = string2.length();
        if (string.length() >= n) {
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                char c2 = string2.charAt(i);
                if (Character.toLowerCase(c) == Character.toLowerCase(c2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static {
        LOCK_DESKTOP_CREATION = new Object();
    }
}

