/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.io.Serializable;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.html.HTMLDocument;
import org.fife.ui.autocomplete.Util;

class TipUtil {
    private TipUtil() {
    }

    public static Color getToolTipBackground() {
        Color color = UIManager.getColor("ToolTip.background");
        if ((color == null || UIManager.getLookAndFeel().getName().equals("Nimbus")) && (color = UIManager.getColor("info")) == null) {
            color = SystemColor.info;
        }
        if (color instanceof ColorUIResource) {
            color = new Color(color.getRGB());
        }
        return color;
    }

    public static void tweakTipEditorPane(JEditorPane jEditorPane) {
        Serializable serializable;
        Color color;
        if (UIManager.getLookAndFeel().getName().equals("Nimbus")) {
            color = jEditorPane.getSelectionColor();
            serializable = jEditorPane.getSelectedTextColor();
            jEditorPane.setUI(new BasicEditorPaneUI());
            jEditorPane.setSelectedTextColor((Color)serializable);
            jEditorPane.setSelectionColor(color);
        }
        jEditorPane.setEditable(false);
        jEditorPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jEditorPane.getCaret().setSelectionVisible(true);
        color = UIManager.getColor("Label.foreground");
        if (color == null) {
            color = SystemColor.text;
        }
        jEditorPane.setForeground(color);
        jEditorPane.setBackground(TipUtil.getToolTipBackground());
        serializable = UIManager.getFont("Label.font");
        if (serializable == null) {
            serializable = new Font("SansSerif", 0, 12);
        }
        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        hTMLDocument.getStyleSheet().addRule("body { font-family: " + ((Font)serializable).getFamily() + "; font-size: " + ((Font)serializable).getSize() + "pt" + "; color: " + Util.getHexString(color) + "; }");
        URL uRL = TipUtil.class.getResource("bullet_black.png");
        if (uRL != null) {
            hTMLDocument.getStyleSheet().addRule("ul { list-style-image: " + uRL.toString() + "; }");
        }
    }
}

