/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.OutlineHighlightPainter;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletionChoicesWindow;
import org.fife.ui.autocomplete.TipUtil;
import org.fife.ui.autocomplete.Util;
import org.fife.ui.rsyntaxtextarea.PopupWindowDecorator;

class ParameterizedCompletionDescriptionToolTip {
    private JWindow tooltip;
    Highlighter.HighlightPainter p;
    List tags;
    private AutoCompletion ac;
    private JLabel descLabel;
    private ParameterizedCompletion pc;
    private Listener listener;
    private int minPos;
    private Position maxPos;
    private ParameterizedCompletionChoicesWindow paramChoicesWindow;
    private String paramPrefix;
    private int lastSelectedParam;
    private Object oldTabKey;
    private Action oldTabAction;
    private Object oldShiftTabKey;
    private Action oldShiftTabAction;
    private Object oldUpKey;
    private Action oldUpAction;
    private Object oldDownKey;
    private Action oldDownAction;
    private Object oldEnterKey;
    private Action oldEnterAction;
    private Object oldEscapeKey;
    private Action oldEscapeAction;
    private Object oldClosingKey;
    private Action oldClosingAction;
    private static final String IM_KEY_TAB = "ParamCompDescTip.Tab";
    private static final String IM_KEY_SHIFT_TAB = "ParamCompDescTip.ShiftTab";
    private static final String IM_KEY_UP = "ParamCompDescTip.Up";
    private static final String IM_KEY_DOWN = "ParamCompDescTip.Down";
    private static final String IM_KEY_ESCAPE = "ParamCompDescTip.Escape";
    private static final String IM_KEY_ENTER = "ParamCompDescTip.Enter";
    private static final String IM_KEY_CLOSING = "ParamCompDescTip.Closing";

    public ParameterizedCompletionDescriptionToolTip(Window window, AutoCompletion autoCompletion, ParameterizedCompletion parameterizedCompletion) {
        this.tooltip = new JWindow(window);
        this.ac = autoCompletion;
        this.pc = parameterizedCompletion;
        this.descLabel = new JLabel();
        this.descLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        this.descLabel.setOpaque(true);
        this.descLabel.setBackground(TipUtil.getToolTipBackground());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.descLabel);
        this.tooltip.setContentPane(jPanel);
        PopupWindowDecorator popupWindowDecorator = PopupWindowDecorator.get();
        if (popupWindowDecorator != null) {
            popupWindowDecorator.decorate(this.tooltip);
        }
        this.lastSelectedParam = -1;
        this.updateText(0);
        this.tooltip.setFocusableWindowState(false);
        this.listener = new Listener();
        this.p = new OutlineHighlightPainter(Color.GRAY);
        this.tags = new ArrayList(1);
        this.paramChoicesWindow = this.createParamChoicesWindow();
    }

    private ParameterizedCompletionChoicesWindow createParamChoicesWindow() {
        ParameterizedCompletionChoicesWindow parameterizedCompletionChoicesWindow = new ParameterizedCompletionChoicesWindow(this.tooltip.getOwner(), this.ac, this);
        parameterizedCompletionChoicesWindow.initialize(this.pc);
        return parameterizedCompletionChoicesWindow;
    }

    private Highlighter.Highlight getCurrentParameterHighlight() {
        JTextComponent jTextComponent = this.ac.getTextComponent();
        int n = jTextComponent.getCaretPosition();
        if (n > 0) {
            --n;
        }
        List list = this.getParameterHighlights();
        for (int i = 0; i < list.size(); ++i) {
            Highlighter.Highlight highlight = (Highlighter.Highlight)list.get(i);
            if (n < highlight.getStartOffset() || n >= highlight.getEndOffset()) continue;
            return highlight;
        }
        return null;
    }

    private int getCurrentParameterStartOffset() {
        Highlighter.Highlight highlight = this.getCurrentParameterHighlight();
        return highlight != null ? highlight.getStartOffset() + 1 : -1;
    }

    private List getParameterHighlights() {
        ArrayList<Highlighter.Highlight> arrayList = new ArrayList<Highlighter.Highlight>(1);
        JTextComponent jTextComponent = this.ac.getTextComponent();
        Highlighter.Highlight[] highlightArray = jTextComponent.getHighlighter().getHighlights();
        for (int i = 0; i < highlightArray.length; ++i) {
            if (highlightArray[i].getPainter() != this.p) continue;
            arrayList.add(highlightArray[i]);
        }
        return arrayList;
    }

    boolean insertSelectedChoice() {
        String string;
        if (this.paramChoicesWindow != null && this.paramChoicesWindow.isVisible() && (string = this.paramChoicesWindow.getSelectedChoice()) != null) {
            JTextComponent jTextComponent = this.ac.getTextComponent();
            Highlighter.Highlight highlight = this.getCurrentParameterHighlight();
            if (highlight != null) {
                jTextComponent.setSelectionStart(highlight.getStartOffset() + 1);
                jTextComponent.setSelectionEnd(highlight.getEndOffset());
                jTextComponent.replaceSelection(string);
                this.moveToNextParam();
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
            }
            return true;
        }
        return false;
    }

    private void installKeyBindings() {
        if (AutoCompletion.getDebug()) {
            System.out.println("ToolTip: Installing keybindings");
        }
        JTextComponent jTextComponent = this.ac.getTextComponent();
        InputMap inputMap = jTextComponent.getInputMap();
        ActionMap actionMap = jTextComponent.getActionMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(9, 0);
        this.oldTabKey = inputMap.get(keyStroke);
        inputMap.put(keyStroke, IM_KEY_TAB);
        this.oldTabAction = actionMap.get(IM_KEY_TAB);
        actionMap.put(IM_KEY_TAB, new NextParamAction());
        keyStroke = KeyStroke.getKeyStroke(9, 1);
        this.oldShiftTabKey = inputMap.get(keyStroke);
        inputMap.put(keyStroke, IM_KEY_SHIFT_TAB);
        this.oldShiftTabAction = actionMap.get(IM_KEY_SHIFT_TAB);
        actionMap.put(IM_KEY_SHIFT_TAB, new PrevParamAction());
        keyStroke = KeyStroke.getKeyStroke(38, 0);
        this.oldUpKey = inputMap.get(keyStroke);
        inputMap.put(keyStroke, IM_KEY_UP);
        this.oldUpAction = actionMap.get(IM_KEY_UP);
        actionMap.put(IM_KEY_UP, new NextChoiceAction(-1, this.oldUpAction));
        keyStroke = KeyStroke.getKeyStroke(40, 0);
        this.oldDownKey = inputMap.get(keyStroke);
        inputMap.put(keyStroke, IM_KEY_DOWN);
        this.oldDownAction = actionMap.get(IM_KEY_DOWN);
        actionMap.put(IM_KEY_DOWN, new NextChoiceAction(1, this.oldDownAction));
        keyStroke = KeyStroke.getKeyStroke(10, 0);
        this.oldEnterKey = inputMap.get(keyStroke);
        inputMap.put(keyStroke, IM_KEY_ENTER);
        this.oldEnterAction = actionMap.get(IM_KEY_ENTER);
        actionMap.put(IM_KEY_ENTER, new GotoEndAction());
        keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.oldEscapeKey = inputMap.get(keyStroke);
        inputMap.put(keyStroke, IM_KEY_ESCAPE);
        this.oldEscapeAction = actionMap.get(IM_KEY_ESCAPE);
        actionMap.put(IM_KEY_ESCAPE, new HideAction());
        char c = this.pc.getProvider().getParameterListEnd();
        keyStroke = KeyStroke.getKeyStroke(c);
        this.oldClosingKey = inputMap.get(keyStroke);
        inputMap.put(keyStroke, IM_KEY_CLOSING);
        this.oldClosingAction = actionMap.get(IM_KEY_CLOSING);
        actionMap.put(IM_KEY_CLOSING, new ClosingAction());
    }

    private void moveToNextParam() {
        JTextComponent jTextComponent = this.ac.getTextComponent();
        int n = jTextComponent.getCaretPosition();
        int n2 = this.tags.size();
        if (n2 == 0) {
            jTextComponent.setCaretPosition(this.maxPos.getOffset());
            this.setVisible(false, false);
        }
        Highlighter.Highlight highlight = null;
        int n3 = -1;
        List list = this.getParameterHighlights();
        for (int i = 0; i < list.size(); ++i) {
            Highlighter.Highlight highlight2 = (Highlighter.Highlight)list.get(i);
            if (highlight != null && highlight.getStartOffset() >= n && (highlight2.getStartOffset() <= n || highlight2.getStartOffset() > highlight.getStartOffset())) continue;
            highlight = highlight2;
            n3 = i;
        }
        if (highlight != null && n <= highlight.getStartOffset()) {
            jTextComponent.setSelectionStart(highlight.getStartOffset() + 1);
            jTextComponent.setSelectionEnd(highlight.getEndOffset());
            this.updateText(n3);
        } else {
            jTextComponent.setCaretPosition(this.maxPos.getOffset());
            this.setVisible(false, false);
        }
    }

    private void moveToPreviousParam() {
        JTextComponent jTextComponent = this.ac.getTextComponent();
        int n = this.tags.size();
        if (n == 0) {
            jTextComponent.setCaretPosition(this.maxPos.getOffset());
            this.setVisible(false, false);
        }
        int n2 = jTextComponent.getCaretPosition();
        int n3 = jTextComponent.getSelectionStart() - 1;
        Highlighter.Highlight highlight = null;
        int n4 = 0;
        List list = this.getParameterHighlights();
        for (int i = 0; i < list.size(); ++i) {
            Highlighter.Highlight highlight2 = (Highlighter.Highlight)list.get(i);
            if (highlight != null && highlight.getStartOffset() < n2 && (highlight2.getStartOffset() >= n3 || highlight2.getStartOffset() <= highlight.getStartOffset())) continue;
            highlight = highlight2;
            n4 = i;
        }
        if (n4 == 0 && this.lastSelectedParam == 0 && list.size() > 1) {
            n4 = list.size() - 1;
            highlight = (Highlighter.Highlight)list.get(n4);
            jTextComponent.setSelectionStart(highlight.getStartOffset() + 1);
            jTextComponent.setSelectionEnd(highlight.getEndOffset());
            this.updateText(n4);
        } else if (highlight != null && n2 > highlight.getStartOffset()) {
            jTextComponent.setSelectionStart(highlight.getStartOffset() + 1);
            jTextComponent.setSelectionEnd(highlight.getEndOffset());
            this.updateText(n4);
        } else {
            jTextComponent.setCaretPosition(this.maxPos.getOffset());
            this.setVisible(false, false);
        }
    }

    private void prepareParamChoicesWindow() {
        if (this.paramChoicesWindow != null) {
            int n = this.getCurrentParameterStartOffset();
            if (n == -1) {
                this.paramChoicesWindow.setVisible(false);
                return;
            }
            JTextComponent jTextComponent = this.ac.getTextComponent();
            try {
                Rectangle rectangle = jTextComponent.modelToView(n);
                Point point = new Point(rectangle.x, rectangle.y);
                SwingUtilities.convertPointToScreen(point, jTextComponent);
                rectangle.x = point.x;
                rectangle.y = point.y;
                this.paramChoicesWindow.setLocationRelativeTo(rectangle);
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                badLocationException.printStackTrace();
            }
            this.paramChoicesWindow.setParameter(this.lastSelectedParam, this.paramPrefix);
        }
    }

    private void removeParameterHighlights() {
        JTextComponent jTextComponent = this.ac.getTextComponent();
        Highlighter highlighter = jTextComponent.getHighlighter();
        for (int i = 0; i < this.tags.size(); ++i) {
            highlighter.removeHighlight(this.tags.get(i));
        }
        this.tags.clear();
    }

    public void setLocationRelativeTo(Rectangle rectangle) {
        int n;
        Rectangle rectangle2 = Util.getScreenBoundsForPoint(rectangle.x, rectangle.y);
        int n2 = rectangle.y - 5 - this.tooltip.getHeight();
        if (n2 < 0) {
            n2 = rectangle.y + rectangle.height + 5;
        }
        if ((n = rectangle.x) < rectangle2.x) {
            n = rectangle2.x;
        } else if (n + this.tooltip.getWidth() > rectangle2.x + rectangle2.width) {
            n = rectangle2.x + rectangle2.width - this.tooltip.getWidth();
        }
        this.tooltip.setLocation(n, n2);
    }

    public void setVisible(boolean bl, boolean bl2) {
        if (bl != this.tooltip.isVisible()) {
            JTextComponent jTextComponent = this.ac.getTextComponent();
            if (bl) {
                this.listener.install(jTextComponent, bl2);
                if (this.paramChoicesWindow == null) {
                    this.paramChoicesWindow = this.createParamChoicesWindow();
                }
                this.prepareParamChoicesWindow();
            } else {
                this.listener.uninstall();
            }
            this.tooltip.setVisible(bl);
            if (this.paramChoicesWindow != null) {
                this.paramChoicesWindow.setVisible(bl);
            }
        }
    }

    private void uninstallKeyBindings() {
        if (AutoCompletion.getDebug()) {
            System.out.println("ToolTip: Uninstalling keybindings");
        }
        JTextComponent jTextComponent = this.ac.getTextComponent();
        InputMap inputMap = jTextComponent.getInputMap();
        ActionMap actionMap = jTextComponent.getActionMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(9, 0);
        inputMap.put(keyStroke, this.oldTabKey);
        actionMap.put(IM_KEY_TAB, this.oldTabAction);
        keyStroke = KeyStroke.getKeyStroke(9, 1);
        inputMap.put(keyStroke, this.oldShiftTabKey);
        actionMap.put(IM_KEY_SHIFT_TAB, this.oldShiftTabAction);
        keyStroke = KeyStroke.getKeyStroke(38, 0);
        inputMap.put(keyStroke, this.oldUpKey);
        actionMap.put(IM_KEY_UP, this.oldUpAction);
        keyStroke = KeyStroke.getKeyStroke(40, 0);
        inputMap.put(keyStroke, this.oldDownKey);
        actionMap.put(IM_KEY_DOWN, this.oldDownAction);
        keyStroke = KeyStroke.getKeyStroke(10, 0);
        inputMap.put(keyStroke, this.oldEnterKey);
        actionMap.put(IM_KEY_ENTER, this.oldEnterAction);
        keyStroke = KeyStroke.getKeyStroke(27, 0);
        inputMap.put(keyStroke, this.oldEscapeKey);
        actionMap.put(IM_KEY_ESCAPE, this.oldEscapeAction);
        char c = this.pc.getProvider().getParameterListEnd();
        keyStroke = KeyStroke.getKeyStroke(c);
        inputMap.put(keyStroke, this.oldClosingKey);
        actionMap.put(IM_KEY_CLOSING, this.oldClosingAction);
    }

    private boolean updateText() {
        JTextComponent jTextComponent = this.ac.getTextComponent();
        int n = jTextComponent.getSelectionStart();
        int n2 = jTextComponent.getSelectionEnd();
        int n3 = -1;
        this.paramPrefix = null;
        List list = this.getParameterHighlights();
        for (int i = 0; i < list.size(); ++i) {
            Highlighter.Highlight highlight = (Highlighter.Highlight)list.get(i);
            int n4 = highlight.getStartOffset() + 1;
            if (n < n4 || n > highlight.getEndOffset()) continue;
            try {
                this.paramPrefix = n == n4 && n2 == highlight.getEndOffset() ? null : jTextComponent.getText(n4, n - n4);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                this.paramPrefix = null;
            }
            n3 = i;
            break;
        }
        return this.updateText(n3);
    }

    private boolean updateText(int n) {
        ParameterizedCompletion.Parameter parameter;
        String string;
        if (n == this.lastSelectedParam) {
            return false;
        }
        this.lastSelectedParam = n;
        StringBuffer stringBuffer = new StringBuffer("<html>");
        int n2 = this.pc.getParamCount();
        for (int i = 0; i < n2; ++i) {
            int n3;
            if (i == n) {
                stringBuffer.append("<b>");
            }
            if ((n3 = (string = this.pc.getParam(i).toString()).indexOf(60)) > -1) {
                stringBuffer.append(string.substring(0, n3));
                stringBuffer.append("&lt;");
                block5: for (int j = n3 + 1; j < string.length(); ++j) {
                    char c = string.charAt(j);
                    switch (c) {
                        case '<': {
                            stringBuffer.append("&lt;");
                            continue block5;
                        }
                        case '>': {
                            stringBuffer.append("&gt;");
                            continue block5;
                        }
                        default: {
                            stringBuffer.append(c);
                        }
                    }
                }
            } else {
                stringBuffer.append(string);
            }
            if (i == n) {
                stringBuffer.append("</b>");
            }
            if (i >= n2 - 1) continue;
            stringBuffer.append(this.pc.getProvider().getParameterListSeparator());
        }
        if (n >= 0 && n < n2 && (string = (parameter = this.pc.getParam(n)).getDescription()) != null) {
            stringBuffer.append("<br>");
            stringBuffer.append(string);
        }
        this.descLabel.setText(stringBuffer.toString());
        this.tooltip.pack();
        return true;
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this.tooltip);
        if (this.paramChoicesWindow != null) {
            this.paramChoicesWindow.updateUI();
        }
    }

    private class PrevParamAction
    extends AbstractAction {
        private PrevParamAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ParameterizedCompletionDescriptionToolTip.this.moveToPreviousParam();
        }
    }

    private class NextParamAction
    extends AbstractAction {
        private NextParamAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ParameterizedCompletionDescriptionToolTip.this.moveToNextParam();
        }
    }

    private class NextChoiceAction
    extends AbstractAction {
        private Action oldAction;
        private int amount;

        public NextChoiceAction(int n, Action action) {
            this.amount = n;
            this.oldAction = action;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ParameterizedCompletionDescriptionToolTip.this.paramChoicesWindow != null && ParameterizedCompletionDescriptionToolTip.this.paramChoicesWindow.isVisible()) {
                ParameterizedCompletionDescriptionToolTip.this.paramChoicesWindow.incSelection(this.amount);
            } else if (this.oldAction != null) {
                this.oldAction.actionPerformed(actionEvent);
            } else {
                ParameterizedCompletionDescriptionToolTip.this.setVisible(false, false);
            }
        }
    }

    private class Listener
    implements FocusListener,
    CaretListener {
        private Listener() {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            if (ParameterizedCompletionDescriptionToolTip.this.maxPos == null) {
                ParameterizedCompletionDescriptionToolTip.this.setVisible(false, false);
                return;
            }
            int n = caretEvent.getDot();
            if (n < ParameterizedCompletionDescriptionToolTip.this.minPos || n >= ParameterizedCompletionDescriptionToolTip.this.maxPos.getOffset()) {
                ParameterizedCompletionDescriptionToolTip.this.setVisible(false, false);
                return;
            }
            ParameterizedCompletionDescriptionToolTip.this.updateText();
            if (ParameterizedCompletionDescriptionToolTip.this.tooltip.isVisible()) {
                ParameterizedCompletionDescriptionToolTip.this.prepareParamChoicesWindow();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            ParameterizedCompletionDescriptionToolTip.this.setVisible(false, false);
        }

        private String getParamText(ParameterizedCompletion.Parameter parameter) {
            String string = parameter.getName();
            if (string == null && (string = parameter.getType()) == null) {
                string = "arg";
            }
            return string;
        }

        public void install(JTextComponent jTextComponent, boolean bl) {
            jTextComponent.addCaretListener(this);
            jTextComponent.addFocusListener(this);
            ParameterizedCompletionDescriptionToolTip.this.installKeyBindings();
            StringBuffer stringBuffer = new StringBuffer();
            if (bl) {
                stringBuffer.append(ParameterizedCompletionDescriptionToolTip.this.pc.getProvider().getParameterListStart());
            }
            int n = jTextComponent.getCaretPosition() + stringBuffer.length();
            int n2 = ParameterizedCompletionDescriptionToolTip.this.pc.getParamCount();
            ArrayList<Point> arrayList = null;
            if (n2 > 0) {
                arrayList = new ArrayList<Point>(n2);
            }
            Highlighter highlighter = jTextComponent.getHighlighter();
            try {
                Object object;
                int n3;
                ParameterizedCompletionDescriptionToolTip.this.minPos = n;
                ParameterizedCompletionDescriptionToolTip.this.maxPos = jTextComponent.getDocument().createPosition(n - stringBuffer.length());
                int n4 = 0;
                int n5 = n;
                for (n3 = 0; n3 < n2; ++n3) {
                    object = ParameterizedCompletionDescriptionToolTip.this.pc.getParam(n3);
                    String string = this.getParamText((ParameterizedCompletion.Parameter)object);
                    if (n3 == 0) {
                        n4 = string.length();
                    }
                    stringBuffer.append(string);
                    int n6 = n5 + string.length();
                    arrayList.add(new Point(n5, n6));
                    String string2 = ParameterizedCompletionDescriptionToolTip.this.pc.getProvider().getParameterListSeparator();
                    if (n3 >= n2 - 1 || string2 == null) continue;
                    stringBuffer.append(string2);
                    n5 = n6 + string2.length();
                }
                stringBuffer.append(ParameterizedCompletionDescriptionToolTip.this.pc.getProvider().getParameterListEnd());
                jTextComponent.replaceSelection(stringBuffer.toString());
                for (n3 = 0; n3 < n2; ++n3) {
                    object = (Point)arrayList.get(n3);
                    ParameterizedCompletionDescriptionToolTip.this.tags.add(highlighter.addHighlight(((Point)object).x - 1, ((Point)object).y, ParameterizedCompletionDescriptionToolTip.this.p));
                }
                jTextComponent.setCaretPosition(n);
                if (ParameterizedCompletionDescriptionToolTip.this.pc.getParamCount() > 0) {
                    jTextComponent.moveCaretPosition(n + n4);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        public void uninstall() {
            JTextComponent jTextComponent = ParameterizedCompletionDescriptionToolTip.this.ac.getTextComponent();
            jTextComponent.removeCaretListener(this);
            jTextComponent.removeFocusListener(this);
            ParameterizedCompletionDescriptionToolTip.this.uninstallKeyBindings();
            ParameterizedCompletionDescriptionToolTip.this.maxPos = null;
            ParameterizedCompletionDescriptionToolTip.this.minPos = -1;
            ParameterizedCompletionDescriptionToolTip.this.removeParameterHighlights();
        }
    }

    private class HideAction
    extends AbstractAction {
        private HideAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ParameterizedCompletionDescriptionToolTip.this.paramChoicesWindow != null && ParameterizedCompletionDescriptionToolTip.this.paramChoicesWindow.isVisible()) {
                ParameterizedCompletionDescriptionToolTip.this.paramChoicesWindow.setVisible(false);
                ParameterizedCompletionDescriptionToolTip.this.paramChoicesWindow = null;
            } else {
                ParameterizedCompletionDescriptionToolTip.this.setVisible(false, false);
            }
        }
    }

    private class ClosingAction
    extends AbstractAction {
        private ClosingAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = ParameterizedCompletionDescriptionToolTip.this.ac.getTextComponent();
            int n = jTextComponent.getCaretPosition();
            char c = ParameterizedCompletionDescriptionToolTip.this.pc.getProvider().getParameterListEnd();
            if (n >= ParameterizedCompletionDescriptionToolTip.this.maxPos.getOffset() - 1) {
                if (n == ParameterizedCompletionDescriptionToolTip.this.maxPos.getOffset()) {
                    jTextComponent.replaceSelection(Character.toString(c));
                } else {
                    int n2;
                    char c2;
                    int n3;
                    String string = this.getArgumentText(n);
                    if (string != null && (n3 = this.getCount(string, c2 = ParameterizedCompletionDescriptionToolTip.this.pc.getProvider().getParameterListStart())) > (n2 = this.getCount(string, c))) {
                        jTextComponent.replaceSelection(Character.toString(c));
                        return;
                    }
                    jTextComponent.setCaretPosition(ParameterizedCompletionDescriptionToolTip.this.maxPos.getOffset());
                }
                ParameterizedCompletionDescriptionToolTip.this.setVisible(false, false);
            } else {
                jTextComponent.replaceSelection(Character.toString(c));
            }
        }

        public String getArgumentText(int n) {
            List list = ParameterizedCompletionDescriptionToolTip.this.getParameterHighlights();
            if (list == null || list.size() == 0) {
                return null;
            }
            for (int i = 0; i < list.size(); ++i) {
                Highlighter.Highlight highlight = (Highlighter.Highlight)list.get(i);
                if (n < highlight.getStartOffset() || n > highlight.getEndOffset()) continue;
                int n2 = highlight.getStartOffset() + 1;
                int n3 = highlight.getEndOffset() - n2;
                JTextComponent jTextComponent = ParameterizedCompletionDescriptionToolTip.this.ac.getTextComponent();
                Document document = jTextComponent.getDocument();
                try {
                    return document.getText(n2, n3);
                }
                catch (BadLocationException badLocationException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                    badLocationException.printStackTrace();
                    return null;
                }
            }
            return null;
        }

        public int getCount(String string, char c) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while ((n3 = string.indexOf(c, n2)) > -1) {
                ++n;
                n2 = n3 + 1;
            }
            return n;
        }
    }

    private class GotoEndAction
    extends AbstractAction {
        private GotoEndAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ParameterizedCompletionDescriptionToolTip.this.paramChoicesWindow != null && ParameterizedCompletionDescriptionToolTip.this.paramChoicesWindow.isVisible() && ParameterizedCompletionDescriptionToolTip.this.insertSelectedChoice()) {
                return;
            }
            JTextComponent jTextComponent = ParameterizedCompletionDescriptionToolTip.this.ac.getTextComponent();
            jTextComponent.setCaretPosition(ParameterizedCompletionDescriptionToolTip.this.maxPos.getOffset());
            ParameterizedCompletionDescriptionToolTip.this.setVisible(false, false);
        }
    }
}

