/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.CompletionProviderBase;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.ToolTipSupplier;

public class LanguageAwareCompletionProvider
extends CompletionProviderBase
implements ToolTipSupplier {
    private CompletionProvider defaultProvider;
    private CompletionProvider stringCompletionProvider;
    private CompletionProvider commentCompletionProvider;
    private CompletionProvider docCommentCompletionProvider;

    protected LanguageAwareCompletionProvider() {
    }

    public LanguageAwareCompletionProvider(CompletionProvider completionProvider) {
        this.setDefaultCompletionProvider(completionProvider);
    }

    public void clearParameterizedCompletionParams() {
        throw new UnsupportedOperationException();
    }

    public String getAlreadyEnteredText(JTextComponent jTextComponent) {
        if (!(jTextComponent instanceof RSyntaxTextArea)) {
            return "";
        }
        CompletionProvider completionProvider = this.getProviderFor(jTextComponent);
        return completionProvider != null ? completionProvider.getAlreadyEnteredText(jTextComponent) : null;
    }

    public CompletionProvider getCommentCompletionProvider() {
        return this.commentCompletionProvider;
    }

    public List getCompletionsAt(JTextComponent jTextComponent, Point point) {
        return this.defaultProvider == null ? null : this.defaultProvider.getCompletionsAt(jTextComponent, point);
    }

    protected List getCompletionsImpl(JTextComponent jTextComponent) {
        if (!(jTextComponent instanceof RSyntaxTextArea)) {
            return new ArrayList(0);
        }
        CompletionProvider completionProvider = this.getProviderFor(jTextComponent);
        return completionProvider != null ? completionProvider.getCompletions(jTextComponent) : new ArrayList(0);
    }

    public CompletionProvider getDefaultCompletionProvider() {
        return this.defaultProvider;
    }

    public CompletionProvider getDocCommentCompletionProvider() {
        return this.docCommentCompletionProvider;
    }

    public List getParameterizedCompletions(JTextComponent jTextComponent) {
        CompletionProvider completionProvider = this.getProviderFor(jTextComponent);
        return completionProvider == this.defaultProvider ? completionProvider.getParameterizedCompletions(jTextComponent) : null;
    }

    public char getParameterListEnd() {
        return this.defaultProvider.getParameterListEnd();
    }

    public String getParameterListSeparator() {
        return this.defaultProvider.getParameterListSeparator();
    }

    public char getParameterListStart() {
        return this.defaultProvider.getParameterListStart();
    }

    private CompletionProvider getProviderFor(JTextComponent jTextComponent) {
        int n;
        RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)jTextComponent;
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rSyntaxTextArea.getDocument();
        Token token = rSyntaxDocument.getTokenListForLine(n = rSyntaxTextArea.getCaretLineNumber());
        if (token == null) {
            return this.getDefaultCompletionProvider();
        }
        int n2 = rSyntaxTextArea.getCaretPosition();
        Token token2 = RSyntaxUtilities.getTokenAtOffset((Token)token, (int)n2);
        if (token2 == null) {
            int n3 = rSyntaxDocument.getLastTokenTypeOnLine(n);
            if (n3 == 0) {
                Token token3 = token.getLastPaintableToken();
                if (token3 == null) {
                    return this.getDefaultCompletionProvider();
                }
                n3 = token3.type;
            }
            switch (n3) {
                case 25: {
                    return this.getStringCompletionProvider();
                }
                case 1: 
                case 2: {
                    return this.getCommentCompletionProvider();
                }
                case 3: {
                    return this.getDocCommentCompletionProvider();
                }
            }
            return this.getDefaultCompletionProvider();
        }
        if (n2 == token2.offset) {
            return this.getDefaultCompletionProvider();
        }
        switch (token2.type) {
            case 10: 
            case 25: {
                return this.getStringCompletionProvider();
            }
            case 1: 
            case 2: {
                return this.getCommentCompletionProvider();
            }
            case 3: {
                return this.getDocCommentCompletionProvider();
            }
            case 0: 
            case 5: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                return this.getDefaultCompletionProvider();
            }
        }
        return null;
    }

    public CompletionProvider getStringCompletionProvider() {
        return this.stringCompletionProvider;
    }

    public boolean isAutoActivateOkay(JTextComponent jTextComponent) {
        CompletionProvider completionProvider = this.getProviderFor(jTextComponent);
        return completionProvider != null ? completionProvider.isAutoActivateOkay(jTextComponent) : false;
    }

    public void setCommentCompletionProvider(CompletionProvider completionProvider) {
        this.commentCompletionProvider = completionProvider;
    }

    public void setDefaultCompletionProvider(CompletionProvider completionProvider) {
        if (completionProvider == null) {
            throw new IllegalArgumentException("provider cannot be null");
        }
        this.defaultProvider = completionProvider;
    }

    public void setDocCommentCompletionProvider(CompletionProvider completionProvider) {
        this.docCommentCompletionProvider = completionProvider;
    }

    public void setParameterizedCompletionParams(char c, String string, char c2) {
        throw new UnsupportedOperationException();
    }

    public void setStringCompletionProvider(CompletionProvider completionProvider) {
        this.stringCompletionProvider = completionProvider;
    }

    public String getToolTipText(RTextArea rTextArea, MouseEvent mouseEvent) {
        String string = null;
        List list = this.getCompletionsAt((JTextComponent)rTextArea, mouseEvent.getPoint());
        if (list != null && list.size() > 0) {
            Completion completion = (Completion)list.get(0);
            string = completion.getToolTipText();
        }
        return string;
    }
}

