/*
 * Decompiled with CFR 0.152.
 */
package griffon.swt.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import griffon.swt.SWTApplication;
import griffon.util.ApplicationHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;

public class ImagePropertyEditor
extends AbstractPropertyEditor {
    public void setAsText(String value) throws IllegalArgumentException {
        this.setValue(value);
    }

    public void setValue(Object value) {
        if (null == value) {
            return;
        }
        if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof File) {
            this.handleAsFile((File)value);
        } else if (value instanceof URL) {
            this.handleAsURL((URL)value);
        } else if (value instanceof URI) {
            this.handleAsURI((URI)value);
        } else if (value instanceof InputStream) {
            this.handleAsInputStream((InputStream)value);
        } else {
            throw this.illegalValue(value, Image.class);
        }
    }

    private void handleAsString(String str) {
        this.handleAsURL(((Object)((Object)this)).getClass().getClassLoader().getResource(str));
    }

    private void handleAsFile(File file) {
        try {
            super.setValue((Object)this.newImage(new FileInputStream(file)));
        }
        catch (IOException e) {
            throw this.illegalValue(file, URL.class);
        }
    }

    private void handleAsURL(URL url) {
        try {
            super.setValue((Object)this.newImage(url.openStream()));
        }
        catch (IOException e) {
            throw this.illegalValue(url, URL.class);
        }
    }

    private void handleAsURI(URI uri) {
        try {
            this.handleAsURL(uri.toURL());
        }
        catch (MalformedURLException e) {
            throw this.illegalValue(uri, URL.class);
        }
    }

    private void handleAsInputStream(InputStream stream) {
        super.setValue((Object)this.newImage(stream));
    }

    private Image newImage(InputStream stream) {
        return new Image((Device)this.application().getDisplay(), stream);
    }

    private SWTApplication application() {
        return (SWTApplication)ApplicationHolder.getApplication();
    }
}

