/*
 * Decompiled with CFR 0.152.
 */
package griffon.swt.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import griffon.swt.SWTApplication;
import griffon.util.ApplicationHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;

public class ColorPropertyEditor
extends AbstractPropertyEditor {
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text);
    }

    public void setValue(Object value) {
        if (null == value) {
            return;
        }
        if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof List) {
            this.handleAsList((List)value);
        } else if (value instanceof Map) {
            this.handleAsMap((Map)value);
        } else if (value instanceof Number) {
            this.handleAsNumber((Number)value);
        } else if (value instanceof Color) {
            super.setValue(value);
        } else {
            throw this.illegalValue(value, Color.class);
        }
    }

    private void handleAsString(String str) {
        if (str.startsWith("#")) {
            int r = 0;
            int g = 0;
            int b = 0;
            switch (str.length()) {
                case 4: {
                    r = this.parse(("" + str.charAt(1) + str.charAt(1)).toUpperCase());
                    g = this.parse(("" + str.charAt(2) + str.charAt(2)).toUpperCase());
                    b = this.parse(("" + str.charAt(3) + str.charAt(3)).toUpperCase());
                    break;
                }
                case 7: {
                    r = this.parse(("" + str.charAt(1) + str.charAt(2)).toUpperCase());
                    g = this.parse(("" + str.charAt(3) + str.charAt(4)).toUpperCase());
                    b = this.parse(("" + str.charAt(5) + str.charAt(6)).toUpperCase());
                    break;
                }
                default: {
                    throw this.illegalValue(str, Color.class);
                }
            }
            try {
                super.setValue((Object)this.newColor(r, g, b));
            }
            catch (NumberFormatException e) {
                throw this.illegalValue(str, Color.class, e);
            }
        } else {
            throw this.illegalValue(str, Color.class);
        }
    }

    private void handleAsList(List list) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.addAll(list);
        switch (list.size()) {
            case 3: {
                break;
            }
            default: {
                throw this.illegalValue(list, Color.class);
            }
        }
        int valuesSize = values.size();
        for (int i = 0; i < valuesSize; ++i) {
            Object val = values.get(i);
            if (val instanceof Number) {
                values.set(i, this.parse((Number)val));
                continue;
            }
            if (!(val instanceof CharSequence)) continue;
            values.set(i, this.parse(String.valueOf(val)));
        }
        super.setValue((Object)this.newColor((Integer)values.get(0), (Integer)values.get(1), (Integer)values.get(2)));
    }

    private void handleAsMap(Map map) {
        int r = this.getMapValue(map, "red", 0);
        int g = this.getMapValue(map, "green", 0);
        int b = this.getMapValue(map, "blue", 0);
        super.setValue((Object)this.newColor(r, g, b));
    }

    private int parse(String val) {
        try {
            return Integer.parseInt(String.valueOf(val).trim(), 16) & 0xFF;
        }
        catch (NumberFormatException e) {
            throw this.illegalValue(val, Color.class, e);
        }
    }

    private int parse(Number val) {
        return val.intValue() & 0xFF;
    }

    private int getMapValue(Map map, String key, int defaultValue) {
        Object val = map.get(key);
        if (null == val) {
            val = map.get(String.valueOf(key.charAt(0)));
        }
        if (null == val) {
            return defaultValue;
        }
        if (val instanceof CharSequence) {
            return this.parse(String.valueOf(val));
        }
        if (val instanceof Number) {
            return this.parse((Number)val);
        }
        throw this.illegalValue(map, Color.class);
    }

    private void handleAsNumber(Number value) {
        int c = this.parse(value);
        super.setValue((Object)this.newColor(c, c, c));
    }

    private Color newColor(int r, int g, int b) {
        SWTApplication application = (SWTApplication)ApplicationHolder.getApplication();
        return new Color((Device)application.getDisplay(), r, g, b);
    }
}

