/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTabViewItem;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;

public class TabItem
extends Item {
    TabFolder parent;
    Control control;
    String toolTipText;
    NSTabViewItem nsItem;

    public TabItem(TabFolder parent, int style) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    public TabItem(TabFolder parent, int style, int index) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, index);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        Rectangle result = new Rectangle(0, 0, 0, 0);
        if (this.nsItem.respondsToSelector(OS.sel_accessibilityAttributeValue_)) {
            int posValue = OS.objc_msgSend(this.nsItem.id, OS.sel_accessibilityAttributeValue_, OS.NSAccessibilityPositionAttribute());
            int sizeValue = OS.objc_msgSend(this.nsItem.id, OS.sel_accessibilityAttributeValue_, OS.NSAccessibilitySizeAttribute());
            NSValue val = new NSValue(posValue);
            NSPoint pt = val.pointValue();
            NSWindow window = this.parent.view.window();
            pt.y = this.display.getPrimaryFrame().height - pt.y;
            pt = this.parent.view.convertPoint_fromView_(pt, null);
            pt = window.convertScreenToBase(pt);
            result.x = (int)pt.x;
            result.y = (int)pt.y;
            val = new NSValue(sizeValue);
            NSSize size = val.sizeValue();
            result.width = (int)Math.ceil(size.width);
            result.height = (int)Math.ceil(size.height);
        }
        return result;
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public TabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.nsItem != null) {
            this.nsItem.release();
        }
        this.nsItem = null;
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        int index = this.parent.indexOf(this);
        if (index == this.parent.getSelectionIndex() && this.control != null) {
            this.control.setVisible(false);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.control = null;
    }

    public void setControl(Control control) {
        NSView topView;
        NSView view;
        int selectionIndex;
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control != null && this.control.isDisposed()) {
            this.control = null;
        }
        Control oldControl = this.control;
        Control newControl = control;
        this.control = control;
        int index = this.parent.indexOf(this);
        if (index != (selectionIndex = this.parent.getSelectionIndex())) {
            if (newControl != null) {
                Control selectedControl;
                boolean hideControl = true;
                if (selectionIndex != -1 && (selectedControl = this.parent.getItem(selectionIndex).getControl()) == newControl) {
                    hideControl = false;
                }
                if (hideControl) {
                    newControl.setVisible(false);
                }
            }
        } else {
            if (newControl != null) {
                newControl.setVisible(true);
            }
            if (oldControl != null) {
                oldControl.setVisible(false);
            }
        }
        if (newControl != null) {
            view = newControl.topView();
        } else {
            view = (NSView)new NSView().alloc();
            view.init();
            view.autorelease();
        }
        this.nsItem.setView(view);
        if (oldControl != null && (topView = oldControl.topView()).superview() == null) {
            this.parent.contentView().addSubview(topView, -1, null);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        super.setImage(image);
    }

    public void setText(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.parent.indexOf(this)) == -1) {
            return;
        }
        super.setText(string);
        char[] chars = new char[string.length()];
        string.getChars(0, chars.length, chars, 0);
        int length = this.fixMnemonic(chars);
        NSString str = NSString.stringWithCharacters(chars, length);
        this.nsItem.setLabel(str);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        this.parent.checkToolTip(this);
    }

    String tooltipText() {
        return this.toolTipText;
    }

    void update() {
        this.setText(this.text);
        this.setImage(this.image);
        this.setToolTipText(this.toolTipText);
    }
}

