/*
 * Decompiled with CFR 0.152.
 */
package groovy.swt.factory;

import groovy.lang.GString;
import groovy.lang.GroovyRuntimeException;
import groovy.swt.SwtUtils;
import groovy.swt.factory.AbstractSwtFactory;
import groovy.util.FactoryBuilderSupport;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabItem;

public class WidgetFactory
extends AbstractSwtFactory {
    protected Class beanClass;
    protected int defaultStyle = 0;

    public WidgetFactory(Class beanClass) {
        this.beanClass = beanClass;
    }

    public WidgetFactory(Class beanClass, int style) {
        this.beanClass = beanClass;
        this.defaultStyle = style;
    }

    public Object newInstance(FactoryBuilderSupport builder, Object name, Object value, Map attributes) throws InstantiationException, IllegalAccessException {
        Object parent = builder.getCurrent();
        if (value != null && !(value instanceof String) && !(value instanceof GString)) {
            parent = value;
        }
        String styleProperty = (String)attributes.remove("style");
        int style = this.defaultStyle;
        if (styleProperty != null) {
            style = SwtUtils.parseStyle(SWT.class, styleProperty);
        }
        Object parentWidget = SwtUtils.getParentWidget(parent, attributes);
        Object bean = this.createWidget(parentWidget, style);
        this.setParent(builder, parent, bean);
        if (value instanceof GString) {
            value = value.toString();
        }
        if (value instanceof String) {
            InvokerHelper.setProperty((Object)bean, (String)"text", (Object)value);
        }
        return bean;
    }

    protected Object createWidget(Object parent) throws InstantiationException {
        return this.createWidget(parent, 0);
    }

    protected Object createWidget(Object parent, int style) throws InstantiationException {
        if (this.beanClass == null) {
            throw new InstantiationException("No Class available to create the new widget of beanClass=null");
        }
        try {
            if (parent == null) {
                Class[] types = new Class[]{Integer.TYPE};
                Constructor constructor = this.beanClass.getConstructor(types);
                if (constructor != null) {
                    Object[] arguments = new Object[]{new Integer(style)};
                    return constructor.newInstance(arguments);
                }
            } else {
                Constructor<?>[] constructors = this.beanClass.getConstructors();
                if (constructors != null) {
                    Class<?>[] types;
                    for (Constructor<?> constructor : constructors) {
                        types = constructor.getParameterTypes();
                        if (types.length != 2 || !types[1].isAssignableFrom(Integer.TYPE) || !types[0].isAssignableFrom(parent.getClass())) continue;
                        Object[] arguments = new Object[]{parent, new Integer(style)};
                        return constructor.newInstance(arguments);
                    }
                    for (Constructor<?> constructor : constructors) {
                        types = constructor.getParameterTypes();
                        if (types.length != 1 || !types[0].isAssignableFrom(parent.getClass())) continue;
                        Object[] arguments = new Object[]{parent};
                        return constructor.newInstance(arguments);
                    }
                }
            }
            return this.beanClass.newInstance();
        }
        catch (NoSuchMethodException e) {
            throw new GroovyRuntimeException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new GroovyRuntimeException("Could not instantiate class " + this.beanClass.getName() + " (may be abstract or could not find a suitable constructor): " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new GroovyRuntimeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new GroovyRuntimeException(e.getTargetException().getLocalizedMessage(), (Throwable)e);
        }
    }

    public void setParent(FactoryBuilderSupport builder, Object parent, Object child) {
        parent = builder.getCurrent();
        if (parent instanceof CTabItem) {
            if (!(child instanceof Control)) {
                throw new GroovyRuntimeException("The first child of cTabItem should be " + Control.class.getName());
            }
            CTabItem tabItem = (CTabItem)parent;
            tabItem.setControl((Control)child);
        } else if (parent instanceof TabItem) {
            if (!(child instanceof Control)) {
                throw new GroovyRuntimeException("The first child of tabItem should be " + Control.class.getName());
            }
            TabItem tabItem = (TabItem)parent;
            tabItem.setControl((Control)child);
        } else if (parent instanceof ScrolledComposite) {
            if (!(child instanceof Control)) {
                throw new GroovyRuntimeException("The first child of scrolledComposite should be " + Control.class.getName());
            }
            ScrolledComposite scrolledComposite = (ScrolledComposite)parent;
            scrolledComposite.setContent((Control)child);
        } else if (child instanceof Menu && parent instanceof Shell) {
            Menu menu = (Menu)child;
            Shell shell = (Shell)parent;
            if (0 != (menu.getStyle() & 2)) {
                shell.setMenuBar(menu);
            } else {
                shell.setMenu(menu);
            }
        } else if (child instanceof Menu && parent instanceof Viewer) {
            Menu menu = (Menu)child;
            Control control = ((Viewer)parent).getControl();
            control.setMenu(menu);
        } else if (child instanceof Menu && parent instanceof Control) {
            Menu menu = (Menu)child;
            Control control = (Control)parent;
            control.setMenu(menu);
        }
    }
}

