/*
 * Decompiled with CFR 0.152.
 */
package groovy.swt.factory;

import groovy.lang.GroovyRuntimeException;
import groovy.swt.SwtUtils;
import groovy.swt.factory.AbstractSwtFactory;
import groovy.util.FactoryBuilderSupport;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;

public class LayoutDataFactory
extends AbstractSwtFactory {
    private Class beanClass;

    public LayoutDataFactory(Class beanClass) {
        this.beanClass = beanClass;
    }

    public Object newInstance(FactoryBuilderSupport builder, Object name, Object value, Map attributes) throws InstantiationException, IllegalAccessException {
        Object parent = builder.getCurrent();
        Object bean = this.createWidget(attributes, parent);
        if (parent instanceof Control) {
            Control control = (Control)parent;
            control.setLayoutData(bean);
        } else if (parent instanceof Viewer) {
            Control control = ((Viewer)parent).getControl();
            control.setLayoutData(bean);
        }
        return bean;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object createWidget(Map attributes, Object parent) {
        Object bean = null;
        String styleText = (String)attributes.remove("style");
        if (styleText != null) {
            int style = SwtUtils.parseStyle(this.beanClass, styleText);
            Class[] types = new Class[]{Integer.TYPE};
            try {
                Constructor constructor = this.beanClass.getConstructor(types);
                if (constructor == null) return bean;
                Object[] values = new Object[]{new Integer(style)};
                return constructor.newInstance(values);
            }
            catch (NoSuchMethodException e) {
                throw new GroovyRuntimeException((Throwable)e);
            }
            catch (InstantiationException e) {
                throw new GroovyRuntimeException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new GroovyRuntimeException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new GroovyRuntimeException((Throwable)e);
            }
        }
        try {
            return this.beanClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new GroovyRuntimeException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new GroovyRuntimeException((Throwable)e);
        }
    }
}

