/*
 * Decompiled with CFR 0.152.
 */
package groovy.swt.factory;

import groovy.lang.GroovyRuntimeException;
import groovy.swt.SwtUtils;
import groovy.swt.factory.AbstractSwtFactory;
import groovy.util.FactoryBuilderSupport;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.eclipse.ui.forms.widgets.Section;

public class FormFactory
extends AbstractSwtFactory {
    protected static FormToolkit toolkit;
    private String type;

    public static FormToolkit getToolkit() {
        if (toolkit == null) {
            FormColors formColors = new FormColors(Display.getCurrent() == null ? new Display() : Display.getCurrent());
            toolkit = new FormToolkit(formColors);
        }
        return toolkit;
    }

    public FormFactory(String type) {
        this.type = type;
    }

    public Object newInstance(FactoryBuilderSupport builder, Object name, Object value, Map attributes) throws InstantiationException, IllegalAccessException {
        String text;
        Object parent = builder.getCurrent();
        Composite parentComposite = (Composite)SwtUtils.getParentWidget(parent, attributes);
        String styleProperty = (String)attributes.remove("style");
        int style = 0;
        if (styleProperty != null) {
            style = this.type.equals("formSection") ? SwtUtils.parseStyle(Section.class, styleProperty) : SwtUtils.parseStyle(SWT.class, styleProperty);
        }
        if ((text = (String)attributes.remove("text")) == null && value instanceof String) {
            text = (String)value;
        }
        if (parentComposite != null) {
            Object formWidget = this.getFormWidget(parentComposite, attributes, style, text);
            this.setBeanProperties(formWidget, attributes);
            return formWidget;
        }
        throw new InstantiationException("The parent of the Form must be a Composite instance");
    }

    private Object getFormWidget(Composite parentComposite, Map properties, int style, String text) throws InstantiationException {
        if ("form".equals(this.type)) {
            Form form = FormFactory.getToolkit().createForm(parentComposite);
            form.setText(text);
            return form;
        }
        if ("scrolledForm".equals(this.type)) {
            ScrolledForm scrolledForm = FormFactory.getToolkit().createScrolledForm(parentComposite);
            scrolledForm.setText(text);
            return scrolledForm;
        }
        if ("formButton".equals(this.type)) {
            return FormFactory.getToolkit().createButton(parentComposite, text, style);
        }
        if ("formColors".equals(this.type)) {
            return FormFactory.getToolkit().getColors();
        }
        if ("formComposite".equals(this.type)) {
            return FormFactory.getToolkit().createComposite(parentComposite, style);
        }
        if ("formCompositeSeparator".equals(this.type)) {
            return FormFactory.getToolkit().createCompositeSeparator(parentComposite);
        }
        if ("formExpandableComposite".equals(this.type)) {
            return FormFactory.getToolkit().createExpandableComposite(parentComposite, style);
        }
        if ("formText".equals(this.type)) {
            Text text2 = FormFactory.getToolkit().createText(parentComposite, text, style);
            FormFactory.getToolkit().paintBordersFor(parentComposite);
            return text2;
        }
        if ("formHyperlink".equals(this.type)) {
            return FormFactory.getToolkit().createHyperlink(parentComposite, text, style);
        }
        if ("formImageHyperlink".equals(this.type)) {
            return FormFactory.getToolkit().createImageHyperlink(parentComposite, style);
        }
        if ("formLabel".equals(this.type)) {
            return FormFactory.getToolkit().createLabel(parentComposite, text, style);
        }
        if ("formPageBook".equals(this.type)) {
            return FormFactory.getToolkit().createPageBook(parentComposite, style);
        }
        if ("formPageBookPage".equals(this.type)) {
            if (parentComposite instanceof ScrolledPageBook) {
                ScrolledPageBook pageBook = (ScrolledPageBook)parentComposite;
                String key = (String)properties.remove("key");
                if (key != null) {
                    Composite page = pageBook.createPage((Object)key);
                    pageBook.registerPage((Object)key, (Control)page);
                    return page;
                }
                throw new GroovyRuntimeException("formPageBookPage must have an attribute \"key\" (is null)");
            }
            throw new InstantiationException("The parent of a formPageBookPage must be a formPageBook");
        }
        if ("formSection".equals(this.type)) {
            Section section = FormFactory.getToolkit().createSection(parentComposite, style);
            if (text != null) {
                section.setText(text);
            }
            section.setSeparatorControl((Control)FormFactory.getToolkit().createCompositeSeparator((Composite)section));
            String description = (String)properties.remove("description");
            if (description != null) {
                section.setDescription(description);
            }
            Composite client = FormFactory.getToolkit().createComposite((Composite)section);
            client.setLayout((Layout)new GridLayout());
            section.setClient((Control)client);
            return section;
        }
        if ("formSeparator".equals(this.type)) {
            return FormFactory.getToolkit().createSeparator(parentComposite, style);
        }
        if ("formTable".equals(this.type)) {
            return FormFactory.getToolkit().createTable(parentComposite, style);
        }
        if ("formToolkit".equals(this.type)) {
            return FormFactory.getToolkit();
        }
        if ("formFormattedText".equals(this.type)) {
            boolean parseTags = false;
            boolean expandURLs = false;
            boolean trackFocus = false;
            if (properties.get("parseTags") != null) {
                parseTags = (Boolean)properties.remove("parseTags");
            }
            if (properties.get("expandURLs") != null) {
                expandURLs = (Boolean)properties.remove("expandURLs");
            }
            if (properties.get("trackFocus") != null) {
                trackFocus = (Boolean)properties.remove("trackFocus");
            }
            FormText formText = FormFactory.getToolkit().createFormText(parentComposite, trackFocus);
            HyperlinkSettings hyperlinkSettings = new HyperlinkSettings(Display.getCurrent());
            hyperlinkSettings.setBackground(FormFactory.getToolkit().getColors().getBackground());
            hyperlinkSettings.setActiveBackground(FormFactory.getToolkit().getColors().getBackground());
            hyperlinkSettings.setForeground(new Color((Device)Display.getCurrent(), 0, 0, 255));
            hyperlinkSettings.setActiveForeground(FormFactory.getToolkit().getColors().getForeground());
            formText.setHyperlinkSettings(hyperlinkSettings);
            formText.setText(text, parseTags, expandURLs);
            return formText;
        }
        if ("formTree".equals(this.type)) {
            return FormFactory.getToolkit().createTree(parentComposite, style);
        }
        return null;
    }
}

