/*
 * Decompiled with CFR 0.152.
 */
package groovy.swt.convertor;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorConverter {
    private Logger log = Logger.getLogger(this.getClass().getName());
    private static final ColorConverter instance = new ColorConverter();
    private static String usageText = "Color value should be in the form of '#xxxxxx', 'x,y,z' or a system color name from SWT.COLOR_xxxx";

    public static ColorConverter getInstance() {
        return instance;
    }

    protected RGB parseRGB(String value) {
        StringTokenizer enumeration = new StringTokenizer(value, ",");
        int red = 0;
        int green = 0;
        int blue = 0;
        if (enumeration.hasMoreTokens()) {
            red = this.parseNumber(enumeration.nextToken());
        }
        if (enumeration.hasMoreTokens()) {
            green = this.parseNumber(enumeration.nextToken());
        }
        if (enumeration.hasMoreTokens()) {
            blue = this.parseNumber(enumeration.nextToken());
        }
        return new RGB(red, green, blue);
    }

    protected RGB parseHtml(String value) {
        if (value.length() != 7) {
            throw new IllegalArgumentException(usageText);
        }
        int colorValue = 0;
        try {
            colorValue = Integer.parseInt(value.substring(1), 16);
            Color swingColor = new Color(colorValue);
            return new RGB(swingColor.getRed(), swingColor.getGreen(), swingColor.getBlue());
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(value + "is not a valid Html color\n " + ex);
        }
    }

    public RGB parse(String value) {
        if (value.length() <= 1) {
            throw new IllegalArgumentException(usageText);
        }
        if (value.startsWith("[") && value.endsWith("]")) {
            value = value.substring(1, value.length() - 1);
        }
        if (value.charAt(0) == '#') {
            return this.parseHtml(value);
        }
        if (value.indexOf(44) != -1) {
            return this.parseRGB(value);
        }
        RGB color = this.parseSystemColor(value);
        if (color == null) {
            throw new IllegalArgumentException(usageText);
        }
        return color;
    }

    public RGB parseSystemColor(String value) {
        RGB color = null;
        try {
            Field field = SWT.class.getField("COLOR_" + value.toUpperCase());
            if (field == null) {
                return null;
            }
            color = Display.getCurrent().getSystemColor(field.getInt(null)).getRGB();
        }
        catch (Exception e) {
            color = null;
        }
        return color;
    }

    public RGB parse(List list) {
        if (list.size() != 3) {
            this.log.log(Level.WARNING, "color attribute must [x,y,z]");
            return null;
        }
        int red = this.parseNumber("" + list.get(0));
        int green = this.parseNumber("" + list.get(1));
        int blue = this.parseNumber("" + list.get(2));
        return new RGB(red, green, blue);
    }

    public Object convert(Class type, Object value) {
        RGB answer = null;
        if (value != null) {
            String text = value.toString();
            answer = this.parse(text);
        }
        return answer;
    }

    protected int parseNumber(String text) {
        text = text.trim();
        return Integer.parseInt(text);
    }
}

