/*
 * Decompiled with CFR 0.152.
 */
package groovy.swt;

import groovy.jface.impl.ApplicationWindowImpl;
import groovy.lang.GroovyRuntimeException;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class SwtUtils {
    private static final Log log = LogFactory.getLog(SwtUtils.class);

    public static int parseStyle(Class constantClass, String text) {
        return SwtUtils.parseStyle(constantClass, text, true);
    }

    public static int parseStyle(Class constantClass, String text, boolean toUpperCase) {
        int answer = 0;
        if (text != null) {
            if (toUpperCase) {
                text = text.toUpperCase();
            }
            StringTokenizer enumeration = new StringTokenizer(text, ",");
            while (enumeration.hasMoreTokens()) {
                String token = enumeration.nextToken().trim();
                answer |= SwtUtils.getStyleCode(constantClass, token);
            }
        }
        return answer;
    }

    public static int getStyleCode(Class constantClass, String text) {
        try {
            Field field = constantClass.getField(text);
            if (field == null) {
                log.warn((Object)("Unknown style code: " + text + " will be ignored"));
                return 0;
            }
            return field.getInt(null);
        }
        catch (NoSuchFieldException e) {
            throw new GroovyRuntimeException("The value: " + text + " is not understood ");
        }
        catch (IllegalAccessException e) {
            throw new GroovyRuntimeException("The value: " + text + " is not understood");
        }
    }

    public static void disposeChildren(Composite parent) {
        Control[] children = parent.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control control = children[i];
            control.dispose();
        }
    }

    public static Shell getParentShell(Object parent) {
        if (parent instanceof ApplicationWindow) {
            return ((ApplicationWindowImpl)((Object)parent)).getShell();
        }
        if (parent instanceof Shell) {
            return (Shell)parent;
        }
        return null;
    }

    public static Object getParentWidget(Object parent, Map properties) {
        Object attribute;
        if (parent == null && properties.containsKey("parent") && (attribute = properties.remove("parent")) instanceof Composite) {
            Composite parentWidget = (Composite)attribute;
            SwtUtils.disposeChildren(parentWidget);
            return parentWidget;
        }
        if (parent instanceof ApplicationWindow) {
            return (Composite)((ApplicationWindowImpl)((Object)parent)).getContents();
        }
        if (parent instanceof Form) {
            return ((Form)parent).getBody();
        }
        if (parent instanceof ScrolledForm) {
            return ((ScrolledForm)parent).getBody();
        }
        if (parent instanceof Section) {
            return ((Section)parent).getClient();
        }
        if (parent instanceof CTabItem) {
            return ((CTabItem)parent).getParent();
        }
        if (parent instanceof TabItem) {
            return ((TabItem)parent).getParent();
        }
        if (parent instanceof ExpandItem) {
            return ((ExpandItem)parent).getParent();
        }
        if (parent instanceof Widget) {
            return (Widget)parent;
        }
        if (parent instanceof TableViewer) {
            return ((TableViewer)parent).getTable();
        }
        if (parent instanceof TreeViewer) {
            return ((TreeViewer)parent).getControl();
        }
        return parent;
    }

    public static String parseString(Class pConstantClass, String pText) {
        return SwtUtils.parseString(pConstantClass, pText, true);
    }

    public static String parseString(Class pConstantClass, String pText, boolean pToUpperCase) {
        String ret = "";
        if (pText != null) {
            if (pToUpperCase) {
                pText = pText.toUpperCase();
            }
            try {
                Field field = pConstantClass.getField(pText);
                if (field == null) {
                    log.warn((Object)("Unknown code: " + pText + " will be ignored"));
                    return "";
                }
                return field.get(pText).toString();
            }
            catch (NoSuchFieldException e) {
                throw new GroovyRuntimeException("The value: " + pText + " is not understood ");
            }
            catch (IllegalAccessException e) {
                throw new GroovyRuntimeException("The value: " + pText + " is not understood");
            }
        }
        return ret;
    }

    public static String[] parseStringArray(Class pConstantClass, String pText) {
        return SwtUtils.parseStringArray(pConstantClass, pText, true);
    }

    public static String[] parseStringArray(Class pConstantClass, String pText, boolean pToUpperCase) {
        String[] ret = null;
        int i = 0;
        if (pText != null) {
            if (pToUpperCase) {
                pText = pText.toUpperCase();
            }
            StringTokenizer enumeration = new StringTokenizer(pText, ",");
            ret = new String[enumeration.countTokens()];
            while (enumeration.hasMoreTokens()) {
                String token = enumeration.nextToken().trim();
                ret[i] = new String();
                ret[i] = SwtUtils.parseString(pConstantClass, token, pToUpperCase);
                ++i;
            }
        }
        return ret;
    }

    public static Object parseObject(Class pConstantClass, String pText, boolean pToUpperCase) {
        if (pText != null) {
            if (pToUpperCase) {
                pText = pText.toUpperCase();
            }
            try {
                Field field = pConstantClass.getField(pText);
                if (field == null) {
                    log.warn((Object)("Unknown code: " + pText + " will be ignored"));
                    return null;
                }
                return field.get(pText);
            }
            catch (NoSuchFieldException e) {
                throw new GroovyRuntimeException("The value: " + pText + " is not understood ");
            }
            catch (IllegalAccessException e) {
                throw new GroovyRuntimeException("The value: " + pText + " is not understood");
            }
        }
        return null;
    }
}

