/*
 * Decompiled with CFR 0.152.
 */
package groovy.swt.factory;

import groovy.swt.SwtUtils;
import groovy.swt.factory.AbstractSwtFactory;
import groovy.swt.impl.DragSourceListenerImpl;
import groovy.util.FactoryBuilderSupport;
import java.util.Map;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;

public class DragSourceFactory
extends AbstractSwtFactory {
    public Object newInstance(FactoryBuilderSupport builder, Object name, Object value, Map attributes) throws InstantiationException, IllegalAccessException {
        Object pParent = builder.getCurrent();
        if (!(pParent instanceof Control) && !(pParent instanceof Viewer)) {
            throw new InstantiationException("Parent node of DragSource (" + name + ") must be Widget or Viewer");
        }
        Control parent = pParent instanceof Control ? (Control)pParent : ((Viewer)pParent).getControl();
        String ops = (String)attributes.remove("operations");
        if (ops == null) {
            ops = (String)attributes.remove("style");
        }
        if (ops == null) {
            ops = (String)attributes.remove("type");
        }
        if (ops == null) {
            ops = "copy, move, link";
        }
        int operations = SwtUtils.parseStyle(DND.class, ops, true);
        Transfer[] types = null;
        Object transfer = attributes.remove("transfer");
        if (transfer instanceof String) {
            if (((String)transfer).equalsIgnoreCase("text")) {
                types = new Transfer[]{TextTransfer.getInstance()};
            } else if (((String)transfer).equalsIgnoreCase("html")) {
                types = new Transfer[]{HTMLTransfer.getInstance()};
            } else if (((String)transfer).equalsIgnoreCase("file")) {
                types = new Transfer[]{FileTransfer.getInstance()};
            } else if (((String)transfer).equalsIgnoreCase("rtf")) {
                types = new Transfer[]{RTFTransfer.getInstance()};
            }
        } else if (transfer instanceof Transfer[]) {
            types = (Transfer[])transfer;
        }
        DragSource source = new DragSource(parent, operations);
        source.setTransfer(types);
        DragSourceListenerImpl listener = new DragSourceListenerImpl(attributes, pParent, operations);
        source.addDragListener((DragSourceListener)listener);
        return listener;
    }
}

