/*
 * Decompiled with CFR 0.152.
 */
package groovy.swt.factory;

import groovy.swt.SwtUtils;
import groovy.swt.factory.AbstractSwtFactory;
import groovy.util.FactoryBuilderSupport;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ArrayTableFactory
extends AbstractSwtFactory {
    public Object newInstance(FactoryBuilderSupport builder, Object name, Object value, Map attributes) throws InstantiationException, IllegalAccessException {
        Object parent = builder.getCurrent();
        String styleProperty = (String)attributes.remove("style");
        int mStyle = 0;
        if (styleProperty != null) {
            mStyle = SwtUtils.parseStyle(SWT.class, styleProperty);
        }
        Table table = new Table((Composite)parent, mStyle);
        return table;
    }

    public boolean onHandleNodeAttributes(FactoryBuilderSupport builder, Object node, Map attributes) {
        int i;
        String[] columnNames = (String[])attributes.remove("columnNames");
        Object[][] data = (Object[][])attributes.remove("data");
        int[] width = (int[])attributes.remove("width");
        Table table = (Table)node;
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        int columns = columnNames.length;
        if (width != null && width.length == columns) {
            for (i = 0; i < columns; ++i) {
                this.createColumn(columnNames[i], table, width[i]);
            }
        } else if (width != null && width.length == 1) {
            for (i = 0; i < columns; ++i) {
                this.createColumn(columnNames[i], table, width[0]);
            }
        } else {
            for (i = 0; i < columns; ++i) {
                this.createColumn(columnNames[i], table);
            }
        }
        if (data != null && data.length > 0) {
            for (i = 0; i < data.length; ++i) {
                this.createRow(data[i], table, columns);
            }
        }
        if (width != null && width.length == 0) {
            for (int loopIndex = 0; loopIndex < width.length; ++loopIndex) {
                table.getColumn(loopIndex).pack();
            }
        }
        return true;
    }

    private void createColumn(String pName, Table pTable) {
        TableColumn col1 = new TableColumn(pTable, 16384);
        col1.setText(pName);
        col1.pack();
    }

    private void createColumn(String pName, Table pTable, int width) {
        TableColumn col1 = new TableColumn(pTable, 16384);
        col1.setText(pName);
        col1.setWidth(width);
    }

    private void createRow(Object[] pObj, Table pTable, int NumRows) {
        TableItem item = new TableItem(pTable, 0);
        String[] RowContent = new String[pObj.length];
        for (int i = 0; i < pObj.length; ++i) {
            RowContent[i] = String.valueOf(pObj[i]);
        }
        item.setText(RowContent);
    }
}

