/*
 * Decompiled with CFR 0.152.
 */
package groovy.swt.factory;

import groovy.lang.GString;
import groovy.swt.SwtUtils;
import groovy.swt.convertor.ColorConverter;
import groovy.swt.convertor.PointConverter;
import groovy.util.AbstractFactory;
import groovy.util.FactoryBuilderSupport;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandItem;

public abstract class AbstractSwtFactory
extends AbstractFactory {
    public boolean onHandleNodeAttributes(FactoryBuilderSupport builder, Object node, Map attributes) {
        this.setBeanProperties(node, attributes);
        return true;
    }

    protected void setBeanProperties(Object bean, Map properties) {
        Integer height;
        if (bean instanceof Control) {
            Object colorValue;
            Control control = (Control)bean;
            Object size = properties.remove("size");
            if (size != null) {
                this.setSize(control, size);
            }
            if ((colorValue = properties.remove("background")) != null) {
                Color background = this.getColor(control, colorValue);
                control.setBackground(background);
            }
            if ((colorValue = properties.remove("foreground")) != null) {
                Color foreground = this.getColor(control, colorValue);
                control.setForeground(foreground);
            }
        } else if (bean instanceof ExpandItem && (height = (Integer)properties.remove("height")) != null) {
            ((ExpandItem)bean).setHeight(height.intValue());
        }
        ArrayList<String> propertiesProcessed = new ArrayList<String>();
        for (Map.Entry entry : properties.entrySet()) {
            String property = entry.getKey().toString();
            Object value = entry.getValue();
            Field field = null;
            try {
                field = bean.getClass().getDeclaredField(property);
                if (value instanceof Boolean) {
                    field.setBoolean(bean, (Boolean)value);
                } else if (value instanceof Integer) {
                    field.setInt(bean, (Integer)value);
                } else if (value instanceof Double) {
                    field.setDouble(bean, (Double)value);
                } else if (value instanceof Float) {
                    field.setFloat(bean, ((Float)value).floatValue());
                } else {
                    if (value instanceof GString) {
                        value = value.toString();
                    }
                    if (value instanceof String) {
                        int constValue = SwtUtils.parseStyle(SWT.class, (String)value);
                        field.setInt(bean, constValue);
                    } else {
                        field = null;
                    }
                }
            }
            catch (Exception e) {
                field = null;
            }
            if (field == null) continue;
            propertiesProcessed.add(property);
        }
        for (String prop : propertiesProcessed) {
            properties.remove(prop);
        }
    }

    protected Color getColor(Control control, Object colorValue) {
        Color color = null;
        if (colorValue != null) {
            RGB rgb = null;
            if (colorValue instanceof Color) {
                color = (Color)colorValue;
            } else if (colorValue instanceof List) {
                rgb = ColorConverter.getInstance().parse((List)colorValue);
                color = new Color((Device)control.getDisplay(), rgb);
            } else {
                rgb = ColorConverter.getInstance().parse(colorValue.toString());
                color = new Color((Device)control.getDisplay(), rgb);
            }
        }
        return color;
    }

    protected void setSize(Control control, Object size) {
        Point point = null;
        if (size != null) {
            if (size instanceof Point) {
                point = (Point)size;
            } else if (size instanceof List) {
                point = PointConverter.getInstance().parse((List)size);
            }
            control.setSize(point);
        }
    }
}

