/*
 * Decompiled with CFR 0.152.
 */
package groovy.jface.impl;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.widgets.Composite;

public class PreferencePageFieldEditorImpl
extends FieldEditorPreferencePage {
    private List creatorFieldsfields = new ArrayList();

    public PreferencePageFieldEditorImpl(String title) {
        super(title, 1);
    }

    public void addFieldCreator(Class beanClass, String propertyName, String title) {
        this.creatorFieldsfields.add(new FieldEditorCreator(beanClass, propertyName, title));
    }

    public void addRadioGroupFieldCreator(String propertyName, String title, int numColumns, String[][] labelAndValues, boolean useGroup) {
        this.creatorFieldsfields.add(new RadioGroupFieldEditorCreator(propertyName, title, numColumns, labelAndValues, useGroup));
    }

    protected void createFieldEditors() {
        for (FieldEditorCreator creator : this.creatorFieldsfields) {
            FieldEditor fieldEditor = creator.createField(this.getFieldEditorParent());
            this.addField(fieldEditor);
        }
    }

    public class RadioGroupFieldEditorCreator
    extends FieldEditorCreator {
        int numColumns;
        String[][] labelAndValues;
        boolean useGroup;

        public RadioGroupFieldEditorCreator(String propertyName, String title, int numColumns, String[][] labelAndValues, boolean useGroup) {
            super(RadioGroupFieldEditor.class, propertyName, title);
            this.numColumns = numColumns;
            this.labelAndValues = labelAndValues;
            this.useGroup = useGroup;
        }

        public FieldEditor createField(Composite parent) {
            RadioGroupFieldEditor fieldEditor = new RadioGroupFieldEditor(this.propertyName, this.title, this.numColumns, this.labelAndValues, parent, this.useGroup);
            return fieldEditor;
        }
    }

    public class FieldEditorCreator {
        protected Class beanClass;
        protected String propertyName;
        protected String title;

        public FieldEditorCreator(Class beanClass, String propertyName, String title) {
            this.beanClass = beanClass;
            this.propertyName = propertyName;
            this.title = title;
        }

        public FieldEditor createField(Composite parent) {
            FieldEditor fieldEditor = null;
            try {
                Class[] types = new Class[]{String.class, String.class, Composite.class};
                Constructor constructor = this.beanClass.getConstructor(types);
                if (constructor != null) {
                    Object[] arguments = new Object[]{this.propertyName, this.title, parent};
                    fieldEditor = (FieldEditor)constructor.newInstance(arguments);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return fieldEditor;
        }
    }
}

