/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.IBeanMapProperty;
import org.eclipse.core.databinding.beans.IBeanSetProperty;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.databinding.property.set.SetProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.beans.BeanMapPropertyDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableSetDecorator;

public class BeanSetPropertyDecorator
extends SetProperty
implements IBeanSetProperty {
    private final ISetProperty delegate;
    private final PropertyDescriptor propertyDescriptor;

    public BeanSetPropertyDecorator(ISetProperty delegate, PropertyDescriptor propertyDescriptor) {
        this.delegate = delegate;
        this.propertyDescriptor = propertyDescriptor;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    public Object getElementType() {
        return this.delegate.getElementType();
    }

    public IBeanMapProperty values(String propertyName) {
        return this.values(propertyName, null);
    }

    public IBeanMapProperty values(String propertyName, Class valueType) {
        Class beanClass = (Class)this.delegate.getElementType();
        return this.values(BeanProperties.value(beanClass, propertyName, valueType));
    }

    public IBeanMapProperty values(IBeanValueProperty property) {
        return new BeanMapPropertyDecorator(super.values((IValueProperty)property), property.getPropertyDescriptor());
    }

    public IObservableSet observe(Object source) {
        return new BeanObservableSetDecorator(this.delegate.observe(source), this.propertyDescriptor);
    }

    public IObservableSet observe(Realm realm, Object source) {
        return new BeanObservableSetDecorator(this.delegate.observe(realm, source), this.propertyDescriptor);
    }

    public IObservableFactory setFactory() {
        return this.delegate.setFactory();
    }

    public IObservableFactory setFactory(Realm realm) {
        return this.delegate.setFactory(realm);
    }

    public IObservableSet observeDetail(IObservableValue master) {
        return new BeanObservableSetDecorator(this.delegate.observeDetail(master), this.propertyDescriptor);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

