/*
 * Decompiled with CFR 0.152.
 */
package griffon.swt;

import griffon.core.ApplicationPhase;
import griffon.core.GriffonApplication;
import griffon.core.ShutdownHandler;
import griffon.swt.SWTGriffonApplication;
import griffon.util.ConfigUtils;
import griffon.util.GriffonNameUtils;
import groovy.util.ConfigObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WindowManager
implements ShutdownHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WindowManager.class);
    private final SWTGriffonApplication app;
    private final WindowHelper windowHelper = new WindowHelper();
    private final ShowHelper showHelper = new ShowHelper();
    private final HideHelper hideHelper = new HideHelper();
    private final Map<String, Shell> windows = new ConcurrentHashMap<String, Shell>();

    public WindowManager(SWTGriffonApplication app) {
        this.app = app;
    }

    public Shell findWindow(String name) {
        if (!GriffonNameUtils.isBlank((String)name)) {
            return this.windows.get(name);
        }
        return null;
    }

    public String findWindowName(Shell window) {
        if (window != null) {
            for (Map.Entry<String, Shell> entry : this.windows.entrySet()) {
                if (entry.getValue() != window) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public Shell getStartingWindow() {
        int index;
        Shell window = null;
        Object value = ConfigUtils.getConfigValue((Map)this.app.getConfig(), (String)"swt.windowManager.startingWindow");
        if (LOG.isDebugEnabled()) {
            LOG.debug("swt.windowManager.startingWindow configured to " + value);
        }
        if (value == null || value instanceof ConfigObject) {
            if (this.windows.size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No startingWindow configured, selecting the first one in the list of windows");
                }
                window = this.windows.values().iterator().next();
            }
        } else if (value instanceof String) {
            String windowName = (String)value;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Selecting window " + windowName + " as starting window");
            }
            window = this.findWindow(windowName);
        } else if (value instanceof Number && (index = ((Number)value).intValue()) >= 0 && index < this.windows.size()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Selecting window at index " + index + " as starting window");
            }
            int i = 0;
            Iterator<Shell> iter = this.windows.values().iterator();
            while (iter.hasNext()) {
                if (i == index) {
                    window = iter.next();
                    break;
                }
                ++i;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting window is " + window);
        }
        return window;
    }

    public Collection<Shell> getWindows() {
        return Collections.unmodifiableCollection(this.windows.values());
    }

    public void attach(String name, Shell window) {
        if (window == null || this.windows.values().contains(window)) {
            return;
        }
        window.addShellListener((ShellListener)this.windowHelper);
        window.addListener(22, (Listener)this.showHelper);
        window.addListener(23, (Listener)this.hideHelper);
        this.windows.put(name, window);
    }

    public void detach(Shell window) {
        if (window == null) {
            return;
        }
        if (this.windows.values().contains(window)) {
            window.removeShellListener((ShellListener)this.windowHelper);
            window.removeListener(22, (Listener)this.showHelper);
            window.removeListener(23, (Listener)this.hideHelper);
            this.windows.remove(this.findWindowName(window));
        }
    }

    public void show(final Shell window) {
        if (window == null) {
            return;
        }
        this.app.execInsideUISync(new Runnable(){

            @Override
            public void run() {
                WindowManager.this.app.resolveWindowDisplayHandler().show(window, WindowManager.this.app);
            }
        });
    }

    public void hide(final Shell window) {
        if (window == null) {
            return;
        }
        this.app.execInsideUISync(new Runnable(){

            @Override
            public void run() {
                WindowManager.this.app.resolveWindowDisplayHandler().hide(window, WindowManager.this.app);
            }
        });
    }

    public boolean canShutdown(GriffonApplication app) {
        return true;
    }

    public void onShutdown(GriffonApplication app) {
        for (Shell window : this.windows.values()) {
            if (window.isDisposed() || !window.isVisible()) continue;
            this.hide(window);
        }
    }

    public void handleClose(Widget widget) {
        if (this.app.getPhase() == ApplicationPhase.SHUTDOWN) {
            return;
        }
        int visibleWindows = 0;
        for (Shell window : this.windows.values()) {
            if (window.isDisposed() || !window.isVisible()) continue;
            ++visibleWindows;
        }
        Boolean autoShutdown = (Boolean)this.app.getConfig().flatten().get("application.autoShutdown");
        if (visibleWindows <= 1 && autoShutdown != null && autoShutdown.booleanValue() && !this.app.shutdown()) {
            this.show((Shell)widget);
        }
    }

    private class HideHelper
    implements Listener {
        private HideHelper() {
        }

        public void handleEvent(Event event) {
            WindowManager.this.app.event(GriffonApplication.Event.WINDOW_HIDDEN.getName(), Arrays.asList(event.widget));
        }
    }

    private class ShowHelper
    implements Listener {
        private ShowHelper() {
        }

        public void handleEvent(Event event) {
            WindowManager.this.app.event(GriffonApplication.Event.WINDOW_SHOWN.getName(), Arrays.asList(event.widget));
        }
    }

    private class WindowHelper
    extends ShellAdapter {
        private WindowHelper() {
        }

        public void shellClosed(ShellEvent event) {
            WindowManager.this.hide((Shell)event.getSource());
            WindowManager.this.handleClose((Widget)((Shell)event.getSource()));
        }
    }
}

