/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSClipView;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSScroller;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTScroller;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    NSScrollView scrollView;
    ScrollBar horizontalBar;
    ScrollBar verticalBar;

    Scrollable() {
    }

    public Scrollable(Composite parent, int style) {
        super(parent, style);
    }

    boolean accessibilityIsIgnored(long id2, long sel) {
        if (this.scrollView != null && id2 == this.scrollView.id) {
            return true;
        }
        return super.accessibilityIsIgnored(id2, sel);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        if (this.scrollView != null) {
            NSSize size = new NSSize();
            size.width = width;
            size.height = height;
            int border = this.hasBorder() ? 2 : 0;
            size = NSScrollView.frameSizeForContentSize(size, (this.style & 0x100) != 0, (this.style & 0x200) != 0, border);
            width = (int)size.width;
            height = (int)size.height;
            NSRect frame = this.scrollView.contentView().frame();
            x = (int)((double)x - frame.x);
            y = (int)((double)y - frame.y);
        }
        return new Rectangle(x, y, width, height);
    }

    ScrollBar createScrollBar(int style) {
        long actionSelector;
        if (this.scrollView == null) {
            return null;
        }
        ScrollBar bar = new ScrollBar();
        bar.parent = this;
        bar.style = style;
        bar.display = this.display;
        NSRect rect = new NSRect();
        if ((style & 0x100) != 0) {
            rect.width = 1.0;
        } else {
            rect.height = 1.0;
        }
        NSScroller scroller = (NSScroller)new SWTScroller().alloc();
        scroller.initWithFrame(rect);
        if ((style & 0x100) != 0) {
            this.scrollView.setHorizontalScroller(scroller);
            actionSelector = OS.sel_sendHorizontalSelection;
        } else {
            this.scrollView.setVerticalScroller(scroller);
            actionSelector = OS.sel_sendVerticalSelection;
        }
        bar.view = scroller;
        bar.createJNIRef();
        bar.register();
        if ((this.state & 2) == 0) {
            bar.target = scroller.target();
            bar.actionSelector = scroller.action();
        }
        scroller.setTarget(this.scrollView);
        scroller.setAction(actionSelector);
        if ((this.state & 2) != 0) {
            bar.updateBar(0, 0, 100, 10);
        }
        return bar;
    }

    void createWidget() {
        super.createWidget();
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = this.createScrollBar(256);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = this.createScrollBar(512);
        }
    }

    void deregister() {
        super.deregister();
        if (this.scrollView != null) {
            this.display.removeWidget(this.scrollView);
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if (this.scrollView != null) {
            NSSize size = this.scrollView.contentSize();
            NSClipView contentView = this.scrollView.contentView();
            NSRect bounds = contentView.bounds();
            return new Rectangle((int)bounds.x, (int)bounds.y, (int)size.width, (int)size.height);
        }
        NSRect rect = this.view.bounds();
        return new Rectangle(0, 0, (int)rect.width, (int)rect.height);
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2) || this.hooks(31);
    }

    boolean isEventView(long id2) {
        return id2 == this.eventView().id;
    }

    boolean isTrim(NSView view) {
        if (this.scrollView != null) {
            if (this.scrollView.id == view.id) {
                return true;
            }
            if (this.horizontalBar != null && this.horizontalBar.view.id == view.id) {
                return true;
            }
            if (this.verticalBar != null && this.verticalBar.view.id == view.id) {
                return true;
            }
        }
        return super.isTrim(view);
    }

    void register() {
        super.register();
        if (this.scrollView != null) {
            this.display.addWidget(this.scrollView, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.scrollView != null) {
            this.scrollView.release();
        }
        this.scrollView = null;
    }

    void releaseChildren(boolean destroy) {
        if (this.horizontalBar != null) {
            this.horizontalBar.release(false);
            this.horizontalBar = null;
        }
        if (this.verticalBar != null) {
            this.verticalBar.release(false);
            this.verticalBar = null;
        }
        super.releaseChildren(destroy);
    }

    void sendHorizontalSelection() {
        if ((this.state & 2) == 0 && this.scrollView != null && this.visibleRgn == 0L) {
            this.scrollView.contentView().setCopiesOnScroll(!this.isObscured());
        }
        this.horizontalBar.sendSelection();
    }

    void sendVerticalSelection() {
        if ((this.state & 2) == 0 && this.scrollView != null && this.visibleRgn == 0L) {
            this.scrollView.contentView().setCopiesOnScroll(!this.isObscured());
        }
        this.verticalBar.sendSelection();
    }

    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        if (this.horizontalBar != null) {
            this.horizontalBar.enableWidget(enabled);
        }
        if (this.verticalBar != null) {
            this.verticalBar.enableWidget(enabled);
        }
    }

    boolean setScrollBarVisible(ScrollBar bar, boolean visible) {
        if (this.scrollView == null) {
            return false;
        }
        if ((this.state & 2) == 0) {
            return false;
        }
        if (visible) {
            if ((bar.state & 0x10) == 0) {
                return false;
            }
            bar.state &= 0xFFFFFFEF;
        } else {
            if ((bar.state & 0x10) != 0) {
                return false;
            }
            bar.state |= 0x10;
        }
        if ((bar.style & 0x100) != 0) {
            this.scrollView.setHasHorizontalScroller(visible);
        } else {
            this.scrollView.setHasVerticalScroller(visible);
        }
        bar.sendEvent(visible ? 22 : 23);
        this.sendEvent(11);
        return true;
    }

    void setZOrder() {
        super.setZOrder();
        if (this.scrollView != null) {
            this.scrollView.setDocumentView(this.view);
        }
    }

    NSView topView() {
        if (this.scrollView != null) {
            return this.scrollView;
        }
        return super.topView();
    }

    void updateCursorRects(boolean enabled) {
        super.updateCursorRects(enabled);
        if (this.scrollView == null) {
            return;
        }
        this.updateCursorRects(enabled, this.scrollView);
        NSClipView contentView = this.scrollView.contentView();
        this.updateCursorRects(enabled, contentView);
    }
}

