/*
 * Decompiled with CFR 0.152.
 */
package groovy.swt.factory;

import groovy.lang.Closure;
import groovy.swt.ClosureSupport;
import groovy.swt.SwtUtils;
import groovy.swt.factory.AbstractSwtFactory;
import groovy.swt.impl.ExpansionListenerImpl;
import groovy.swt.impl.HyperLinkListenerImpl;
import groovy.swt.impl.ListenerImpl;
import groovy.swt.impl.LocationListenerImpl;
import groovy.swt.impl.ProgressListenerImpl;
import groovy.swt.impl.StatusTextListenerImpl;
import groovy.util.FactoryBuilderSupport;
import java.util.Map;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.AbstractHyperlink;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormText;

public class ListenerFactory
extends AbstractSwtFactory {
    private Class beanClass;

    public ListenerFactory(Class beanClass) {
        this.beanClass = beanClass;
    }

    public Object newInstance(FactoryBuilderSupport builder, Object name, Object value, Map attributes) throws InstantiationException, IllegalAccessException {
        Object parent = builder.getCurrent();
        String type = (String)attributes.remove("type");
        if (type == null && value != null) {
            type = value.toString();
        }
        if (parent instanceof Browser) {
            Browser browser = (Browser)parent;
            if (this.beanClass.equals(LocationListener.class)) {
                LocationListenerImpl locationListener = new LocationListenerImpl(type);
                browser.addLocationListener((LocationListener)locationListener);
                return locationListener;
            }
            if (this.beanClass.equals(ProgressListener.class)) {
                ProgressListenerImpl progressListener = new ProgressListenerImpl(type);
                browser.addProgressListener((ProgressListener)progressListener);
                return progressListener;
            }
            if (this.beanClass.equals(StatusTextListener.class)) {
                StatusTextListenerImpl statusTextListener = new StatusTextListenerImpl();
                browser.addStatusTextListener((StatusTextListener)statusTextListener);
                return statusTextListener;
            }
        } else {
            if (parent instanceof AbstractHyperlink || parent instanceof FormText) {
                HyperLinkListenerImpl hyperLinkListenerImpl = new HyperLinkListenerImpl(type);
                if (parent instanceof AbstractHyperlink) {
                    ((AbstractHyperlink)parent).addHyperlinkListener((IHyperlinkListener)hyperLinkListenerImpl);
                } else if (parent instanceof FormText) {
                    ((FormText)parent).addHyperlinkListener((IHyperlinkListener)hyperLinkListenerImpl);
                }
                return hyperLinkListenerImpl;
            }
            if (parent instanceof ExpandableComposite) {
                ExpandableComposite expandableComposite = (ExpandableComposite)parent;
                ExpansionListenerImpl expansionListener = new ExpansionListenerImpl(type);
                expandableComposite.addExpansionListener((IExpansionListener)expansionListener);
                return expansionListener;
            }
            if (parent instanceof Widget || parent instanceof Viewer || parent instanceof MenuManager) {
                Object widget = null;
                if (parent instanceof Viewer) {
                    widget = ((Viewer)parent).getControl();
                }
                widget = parent instanceof MenuManager ? ((MenuManager)parent).getMenu() : (Widget)parent;
                int eventType = this.getEventType(type);
                if (eventType == 0) {
                    throw new InstantiationException("No event type specified, could not understand the event: " + type);
                }
                ListenerImpl listenerImpl = new ListenerImpl();
                widget.addListener(eventType, (Listener)listenerImpl);
                return listenerImpl;
            }
        }
        throw new InstantiationException("No factory found for class: " + this.beanClass.getName());
    }

    public boolean isHandlesNodeChildren() {
        return true;
    }

    public boolean onNodeChildren(FactoryBuilderSupport builder, Object node, Closure childContent) {
        ClosureSupport cs = (ClosureSupport)node;
        cs.setClosure(childContent);
        return false;
    }

    protected int getEventType(String type) {
        return SwtUtils.parseStyle(SWT.class, type, false);
    }
}

