/*
 * Decompiled with CFR 0.152.
 */
package groovy.jface.factory;

import groovy.jface.impl.PreferencePageFieldEditorImpl;
import groovy.lang.MissingPropertyException;
import groovy.swt.factory.AbstractSwtFactory;
import groovy.util.FactoryBuilderSupport;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;

public class PreferencesFieldEditorFactory
extends AbstractSwtFactory {
    private Class beanClass;

    public PreferencesFieldEditorFactory(Class beanClass) {
        this.beanClass = beanClass;
    }

    private Object getValueOrThrow(Map properties, String name) {
        Object value = properties.remove(name);
        if (name == null) {
            throw new MissingPropertyException(name, FieldEditor.class);
        }
        return value;
    }

    public Object newInstance(FactoryBuilderSupport builder, Object name, Object value, Map attributes) throws InstantiationException, IllegalAccessException {
        Object parent = builder.getCurrent();
        if (this.beanClass == null) {
            throw new InstantiationException("No Class available to create the FieldEditor");
        }
        if (!(parent instanceof PreferencePage)) {
            throw new InstantiationException("the parent of a PreferencesFieldEditor must be a PreferencePage");
        }
        String propertyName = (String)this.getValueOrThrow(attributes, "propertyName");
        String labelText = (String)this.getValueOrThrow(attributes, "title");
        PreferencePageFieldEditorImpl preferencePageImpl = (PreferencePageFieldEditorImpl)((Object)parent);
        if (this.beanClass.equals(RadioGroupFieldEditor.class)) {
            int numColumns = (Integer)this.getValueOrThrow(attributes, "numColumns");
            Boolean bUseGroup = (Boolean)attributes.remove("useGroup");
            boolean useGroup = false;
            if (bUseGroup != null) {
                useGroup = bUseGroup;
            }
            ArrayList values = (ArrayList)this.getValueOrThrow(attributes, "labelAndValues");
            String[][] labelAndValues = new String[values.size()][2];
            for (int no = 0; no < values.size(); ++no) {
                ArrayList labelValuePair = (ArrayList)values.get(no);
                if (labelValuePair.size() != 2) {
                    throw new MissingPropertyException("Only label and value in labelAndValues field", FieldEditor.class);
                }
                labelAndValues[no][0] = (String)labelValuePair.get(0);
                labelAndValues[no][1] = (String)labelValuePair.get(1);
            }
            preferencePageImpl.addRadioGroupFieldCreator(propertyName, labelText, numColumns, labelAndValues, useGroup);
        } else {
            preferencePageImpl.addFieldCreator(this.beanClass, propertyName, labelText);
        }
        return preferencePageImpl;
    }
}

