/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.cocoa;

import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;

public class NSString
extends NSObject {
    public NSString() {
    }

    public NSString(long id2) {
        super(id2);
    }

    public NSString(id id2) {
        super(id2);
    }

    public String getString() {
        char[] buffer = new char[(int)this.length()];
        this.getCharacters(buffer);
        return new String(buffer);
    }

    public static NSString stringWith(String str) {
        char[] buffer = new char[str.length()];
        str.getChars(0, buffer.length, buffer, 0);
        return NSString.stringWithCharacters(buffer, buffer.length);
    }

    public long UTF8String() {
        return OS.objc_msgSend(this.id, OS.sel_UTF8String);
    }

    public long characterAtIndex(long index) {
        return OS.objc_msgSend(this.id, OS.sel_characterAtIndex_, index);
    }

    public long compare(NSString string) {
        return OS.objc_msgSend(this.id, OS.sel_compare_, string != null ? string.id : 0L);
    }

    public long fileSystemRepresentation() {
        return OS.objc_msgSend(this.id, OS.sel_fileSystemRepresentation);
    }

    public void getCharacters(char[] buffer) {
        OS.objc_msgSend(this.id, OS.sel_getCharacters_, buffer);
    }

    public void getCharacters(char[] buffer, NSRange aRange) {
        OS.objc_msgSend(this.id, OS.sel_getCharacters_range_, buffer, aRange);
    }

    public NSString initWithCharacters(char[] characters, long length) {
        long result = OS.objc_msgSend(this.id, OS.sel_initWithCharacters_length_, characters, length);
        return result == this.id ? this : (result != 0L ? new NSString(result) : null);
    }

    public boolean isEqualToString(NSString aString) {
        return OS.objc_msgSend_bool(this.id, OS.sel_isEqualToString_, aString != null ? aString.id : 0L);
    }

    public NSString lastPathComponent() {
        long result = OS.objc_msgSend(this.id, OS.sel_lastPathComponent);
        return result == this.id ? this : (result != 0L ? new NSString(result) : null);
    }

    public long length() {
        return OS.objc_msgSend(this.id, OS.sel_length);
    }

    public NSString lowercaseString() {
        long result = OS.objc_msgSend(this.id, OS.sel_lowercaseString);
        return result == this.id ? this : (result != 0L ? new NSString(result) : null);
    }

    public NSString pathExtension() {
        long result = OS.objc_msgSend(this.id, OS.sel_pathExtension);
        return result == this.id ? this : (result != 0L ? new NSString(result) : null);
    }

    public NSString stringByAddingPercentEscapesUsingEncoding(long enc) {
        long result = OS.objc_msgSend(this.id, OS.sel_stringByAddingPercentEscapesUsingEncoding_, enc);
        return result == this.id ? this : (result != 0L ? new NSString(result) : null);
    }

    public NSString stringByAppendingPathComponent(NSString str) {
        long result = OS.objc_msgSend(this.id, OS.sel_stringByAppendingPathComponent_, str != null ? str.id : 0L);
        return result == this.id ? this : (result != 0L ? new NSString(result) : null);
    }

    public NSString stringByAppendingString(NSString aString) {
        long result = OS.objc_msgSend(this.id, OS.sel_stringByAppendingString_, aString != null ? aString.id : 0L);
        return result == this.id ? this : (result != 0L ? new NSString(result) : null);
    }

    public NSString stringByDeletingLastPathComponent() {
        long result = OS.objc_msgSend(this.id, OS.sel_stringByDeletingLastPathComponent);
        return result == this.id ? this : (result != 0L ? new NSString(result) : null);
    }

    public NSString stringByDeletingPathExtension() {
        long result = OS.objc_msgSend(this.id, OS.sel_stringByDeletingPathExtension);
        return result == this.id ? this : (result != 0L ? new NSString(result) : null);
    }

    public NSString stringByReplacingOccurrencesOfString(NSString target, NSString replacement) {
        long result = OS.objc_msgSend(this.id, OS.sel_stringByReplacingOccurrencesOfString_withString_, target != null ? target.id : 0L, replacement != null ? replacement.id : 0L);
        return result == this.id ? this : (result != 0L ? new NSString(result) : null);
    }

    public static NSString stringWithCharacters(char[] characters, long length) {
        long result = OS.objc_msgSend(OS.class_NSString, OS.sel_stringWithCharacters_length_, characters, length);
        return result != 0L ? new NSString(result) : null;
    }

    public static NSString stringWithFormat(NSString stringWithFormat) {
        long result = OS.objc_msgSend(OS.class_NSString, OS.sel_stringWithFormat_, stringWithFormat != null ? stringWithFormat.id : 0L);
        return result != 0L ? new NSString(result) : null;
    }

    public static NSString stringWithUTF8String(long nullTerminatedCString) {
        long result = OS.objc_msgSend(OS.class_NSString, OS.sel_stringWithUTF8String_, nullTerminatedCString);
        return result != 0L ? new NSString(result) : null;
    }
}

