/*
 * Decompiled with CFR 0.152.
 */
package griffon.swt;

import griffon.application.StandaloneGriffonApplication;
import griffon.core.UIThreadManager;
import griffon.swt.ConfigurableWindowDisplayHandler;
import griffon.swt.SWTGriffonApplication;
import griffon.swt.SWTUIThreadHandler;
import griffon.swt.WindowDisplayHandler;
import griffon.swt.WindowManager;
import griffon.util.GriffonExceptionHandler;
import griffon.util.UIThreadHandler;
import java.lang.reflect.InvocationTargetException;
import org.codehaus.griffon.runtime.core.AbstractGriffonApplication;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractSWTGriffonApplication
extends AbstractGriffonApplication
implements SWTGriffonApplication,
StandaloneGriffonApplication {
    private final WindowManager windowManager;
    private WindowDisplayHandler windowDisplayHandler;
    private final WindowDisplayHandler defaultWindowDisplayHandler = new ConfigurableWindowDisplayHandler();
    private static final Class[] CTOR_ARGS = new Class[]{String[].class};
    protected final Display defaultDisplay = Display.getDefault();

    public AbstractSWTGriffonApplication() {
        this(EMPTY_ARGS);
    }

    public AbstractSWTGriffonApplication(String[] args) {
        super(args);
        this.windowManager = new WindowManager(this);
        UIThreadManager.getInstance().setUIThreadHandler(this.getUIThreadHandler());
        this.addShutdownHandler(this.windowManager);
    }

    @Override
    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    @Override
    public WindowDisplayHandler getWindowDisplayHandler() {
        return this.windowDisplayHandler;
    }

    @Override
    public void setWindowDisplayHandler(WindowDisplayHandler windowDisplayHandler) {
        this.windowDisplayHandler = windowDisplayHandler;
    }

    protected UIThreadHandler getUIThreadHandler() {
        return new SWTUIThreadHandler();
    }

    @Override
    public final WindowDisplayHandler resolveWindowDisplayHandler() {
        return this.windowDisplayHandler != null ? this.windowDisplayHandler : this.defaultWindowDisplayHandler;
    }

    public void bootstrap() {
        this.initialize();
    }

    public void realize() {
        this.startup();
    }

    public void show() {
        Shell startingWindow = this.windowManager.getStartingWindow();
        this.windowManager.show(startingWindow);
        this.callReady(startingWindow);
    }

    public boolean shutdown() {
        if (super.shutdown()) {
            this.exit();
        }
        return false;
    }

    public void exit() {
        System.exit(0);
    }

    public Object createApplicationContainer() {
        final Shell[] shell = new Shell[1];
        UIThreadManager.getInstance().executeSync(new Runnable(){

            @Override
            public void run() {
                shell[0] = new Shell(AbstractSWTGriffonApplication.this.defaultDisplay, 3312);
            }
        });
        return shell[0];
    }

    protected void callReady(Shell startingWindow) {
        this.ready();
        while (!startingWindow.isDisposed()) {
            if (this.defaultDisplay.readAndDispatch()) continue;
            this.defaultDisplay.sleep();
        }
    }

    public static void run(Class applicationClass, String[] args) {
        GriffonExceptionHandler.registerExceptionHandler();
        StandaloneGriffonApplication app = null;
        try {
            app = (StandaloneGriffonApplication)applicationClass.getDeclaredConstructor(CTOR_ARGS).newInstance(new Object[]{args});
            app.bootstrap();
            app.realize();
            app.show();
        }
        catch (InstantiationException e) {
            GriffonExceptionHandler.sanitize((Throwable)e).printStackTrace();
        }
        catch (IllegalAccessException e) {
            GriffonExceptionHandler.sanitize((Throwable)e).printStackTrace();
        }
        catch (InvocationTargetException e) {
            GriffonExceptionHandler.sanitize((Throwable)e).printStackTrace();
        }
        catch (NoSuchMethodException e) {
            GriffonExceptionHandler.sanitize((Throwable)e).printStackTrace();
        }
    }
}

