/*
 * Decompiled with CFR 0.152.
 */
package groovy.swt.databinding;

import groovy.beans.VetoableASTTransformation;
import groovy.jface.JFaceBuilder;
import groovy.swt.databinding.Bindable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.objectweb.asm.Opcodes;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class BindableASTTransformation
implements ASTTransformation,
Opcodes {
    protected static ClassNode boundClassNode = new ClassNode(Bindable.class);
    protected ClassNode pcsClassNode = new ClassNode(PropertyChangeSupport.class);

    public static boolean hasBindableAnnotation(AnnotatedNode node) {
        for (AnnotationNode annotation : node.getAnnotations()) {
            if (!boundClassNode.equals((Object)annotation.getClassNode())) continue;
            return true;
        }
        return false;
    }

    public void visit(ASTNode[] nodes, SourceUnit source) {
        if (!(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            throw new RuntimeException("Internal error: wrong types: $node.class / $parent.class");
        }
        AnnotationNode node = (AnnotationNode)nodes[0];
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        if (VetoableASTTransformation.hasVetoableAnnotation((AnnotatedNode)parent)) {
            return;
        }
        ClassNode declaringClass = parent.getDeclaringClass();
        if (parent instanceof FieldNode) {
            if (VetoableASTTransformation.hasVetoableAnnotation((AnnotatedNode)parent.getDeclaringClass())) {
                return;
            }
            this.addListenerToProperty(source, node, declaringClass, (FieldNode)parent);
        } else if (parent instanceof ClassNode) {
            this.addListenerToClass(source, node, (ClassNode)parent);
        }
    }

    private void addListenerToProperty(SourceUnit source, AnnotationNode node, ClassNode declaringClass, FieldNode field) {
        String fieldName = field.getName();
        for (PropertyNode propertyNode : declaringClass.getProperties()) {
            if (!propertyNode.getName().equals(fieldName)) continue;
            if (field.isStatic()) {
                source.getErrorCollector().addErrorAndContinue((Message)new SyntaxErrorMessage(new SyntaxException("@groovy.beans.Bindable cannot annotate a static property.", node.getLineNumber(), node.getColumnNumber()), source));
            } else {
                if (this.needsPropertyChangeSupport(declaringClass, source)) {
                    this.addPropertyChangeSupport(declaringClass);
                }
                this.createListenerSetter(source, node, declaringClass, propertyNode);
            }
            return;
        }
        source.getErrorCollector().addErrorAndContinue((Message)new SyntaxErrorMessage(new SyntaxException("@groovy.beans.Bindable must be on a property, not a field.  Try removing the private, protected, or public modifier.", node.getLineNumber(), node.getColumnNumber()), source));
    }

    private void addListenerToClass(SourceUnit source, AnnotationNode node, ClassNode classNode) {
        if (this.needsPropertyChangeSupport(classNode, source)) {
            this.addPropertyChangeSupport(classNode);
        }
        for (PropertyNode propertyNode : classNode.getProperties()) {
            FieldNode field = propertyNode.getField();
            if (BindableASTTransformation.hasBindableAnnotation((AnnotatedNode)field) || field.isStatic() || VetoableASTTransformation.hasVetoableAnnotation((AnnotatedNode)field)) continue;
            this.createListenerSetter(source, node, classNode, propertyNode);
        }
    }

    private void wrapSetterMethod(ClassNode classNode, String propertyName) {
        String getterName = "get" + MetaClassHelper.capitalize((String)propertyName);
        MethodNode setter = classNode.getSetterMethod("set" + MetaClassHelper.capitalize((String)propertyName));
        if (setter != null) {
            Statement code = setter.getCode();
            VariableExpression oldValue = new VariableExpression("$oldValue");
            VariableExpression newValue = new VariableExpression("$newValue");
            BlockStatement block = new BlockStatement();
            block.addStatement((Statement)new ExpressionStatement((Expression)new DeclarationExpression(oldValue, Token.newSymbol((int)100, (int)0, (int)0), (Expression)new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, getterName, (Expression)ArgumentListExpression.EMPTY_ARGUMENTS))));
            block.addStatement(code);
            block.addStatement((Statement)new ExpressionStatement((Expression)new DeclarationExpression(newValue, Token.newSymbol((int)100, (int)0, (int)0), (Expression)new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, getterName, (Expression)ArgumentListExpression.EMPTY_ARGUMENTS))));
            BlockStatement closure = new BlockStatement();
            closure.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, "firePropertyChange", (Expression)new ArgumentListExpression(new Expression[]{new ConstantExpression((Object)propertyName), oldValue, newValue}))));
            block.addStatement((Statement)new ExpressionStatement((Expression)new StaticMethodCallExpression(new ClassNode(JFaceBuilder.class), "realmAsyncExec", (Expression)new ArgumentListExpression((Expression)new ClosureExpression(null, (Statement)closure)))));
            setter.setCode((Statement)block);
        }
    }

    private void createListenerSetter(SourceUnit source, AnnotationNode node, ClassNode classNode, PropertyNode propertyNode) {
        String setterName = "set" + MetaClassHelper.capitalize((String)propertyNode.getName());
        if (classNode.getMethods(setterName).isEmpty()) {
            FieldExpression fieldExpression = new FieldExpression(propertyNode.getField());
            Statement setterBlock = this.createBindableStatement(propertyNode, (Expression)fieldExpression);
            this.createSetterMethod(classNode, propertyNode, setterName, setterBlock);
        } else {
            this.wrapSetterMethod(classNode, propertyNode.getName());
        }
    }

    protected Statement createBindableStatement(PropertyNode propertyNode, Expression fieldExpression) {
        return new ExpressionStatement((Expression)new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, "firePropertyChange", (Expression)new ArgumentListExpression(new Expression[]{new ConstantExpression((Object)propertyNode.getName()), fieldExpression, new BinaryExpression(fieldExpression, Token.newSymbol((int)100, (int)0, (int)0), (Expression)new VariableExpression("value"))})));
    }

    protected void createSetterMethod(ClassNode declaringClass, PropertyNode propertyNode, String setterName, Statement setterBlock) {
        Parameter[] setterParameterTypes = new Parameter[]{new Parameter(propertyNode.getType(), "value")};
        MethodNode setter = new MethodNode(setterName, propertyNode.getModifiers(), ClassHelper.VOID_TYPE, setterParameterTypes, ClassNode.EMPTY_ARRAY, setterBlock);
        setter.setSynthetic(true);
        declaringClass.addMethod(setter);
    }

    protected boolean needsPropertyChangeSupport(ClassNode declaringClass, SourceUnit sourceUnit) {
        boolean foundAdd = false;
        boolean foundRemove = false;
        boolean foundFire = false;
        for (ClassNode consideredClass = declaringClass; consideredClass != null; consideredClass = consideredClass.getSuperClass()) {
            for (MethodNode method : consideredClass.getMethods()) {
                foundAdd = foundAdd || method.getName().equals("addPropertyChangeListener") && method.getParameters().length == 1;
                foundRemove = foundRemove || method.getName().equals("removePropertyChangeListener") && method.getParameters().length == 1;
                boolean bl = foundFire = foundFire || method.getName().equals("firePropertyChange") && method.getParameters().length == 3;
                if (!foundAdd || !foundRemove || !foundFire) continue;
                return false;
            }
        }
        if (foundAdd || foundRemove || foundFire) {
            sourceUnit.getErrorCollector().addErrorAndContinue((Message)new SimpleMessage("@Bindable cannot be processed on " + declaringClass.getName() + " because some but not all of addPropertyChangeListener, removePropertyChange, and firePropertyChange were declared in the current or super classes.", (ProcessingUnit)sourceUnit));
            return false;
        }
        return true;
    }

    protected void addPropertyChangeSupport(ClassNode declaringClass) {
        ClassNode pcsClassNode = ClassHelper.make(PropertyChangeSupport.class);
        ClassNode pclClassNode = ClassHelper.make(PropertyChangeListener.class);
        FieldNode pcsField = declaringClass.addField("this$propertyChangeSupport", 4114, pcsClassNode, (Expression)new ConstructorCallExpression(pcsClassNode, (Expression)new ArgumentListExpression(new Expression[]{new VariableExpression("this")})));
        declaringClass.addMethod(new MethodNode("addPropertyChangeListener", 4097, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(pclClassNode, "listener")}, ClassNode.EMPTY_ARRAY, (Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new FieldExpression(pcsField), "addPropertyChangeListener", (Expression)new ArgumentListExpression(new Expression[]{new VariableExpression("listener")})))));
        declaringClass.addMethod(new MethodNode("addPropertyChangeListener", 4097, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name"), new Parameter(pclClassNode, "listener")}, ClassNode.EMPTY_ARRAY, (Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new FieldExpression(pcsField), "addPropertyChangeListener", (Expression)new ArgumentListExpression(new Expression[]{new VariableExpression("name"), new VariableExpression("listener")})))));
        declaringClass.addMethod(new MethodNode("removePropertyChangeListener", 4097, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(pclClassNode, "listener")}, ClassNode.EMPTY_ARRAY, (Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new FieldExpression(pcsField), "removePropertyChangeListener", (Expression)new ArgumentListExpression(new Expression[]{new VariableExpression("listener")})))));
        declaringClass.addMethod(new MethodNode("removePropertyChangeListener", 4097, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name"), new Parameter(pclClassNode, "listener")}, ClassNode.EMPTY_ARRAY, (Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new FieldExpression(pcsField), "removePropertyChangeListener", (Expression)new ArgumentListExpression(new Expression[]{new VariableExpression("name"), new VariableExpression("listener")})))));
        declaringClass.addMethod(new MethodNode("firePropertyChange", 4097, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name"), new Parameter(ClassHelper.OBJECT_TYPE, "oldValue"), new Parameter(ClassHelper.OBJECT_TYPE, "newValue")}, ClassNode.EMPTY_ARRAY, (Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new FieldExpression(pcsField), "firePropertyChange", (Expression)new ArgumentListExpression(new Expression[]{new VariableExpression("name"), new VariableExpression("oldValue"), new VariableExpression("newValue")})))));
        declaringClass.addMethod(new MethodNode("getPropertyChangeListeners", 4097, pclClassNode.makeArray(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, (Statement)new ReturnStatement(new ExpressionStatement((Expression)new MethodCallExpression((Expression)new FieldExpression(pcsField), "getPropertyChangeListeners", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS)))));
    }
}

