/*
 * Decompiled with CFR 0.152.
 */
package groovy.jface.factory;

import groovy.jface.impl.ApplicationWindowImpl;
import groovy.swt.convertor.PointConverter;
import groovy.swt.factory.WidgetFactory;
import groovy.util.FactoryBuilderSupport;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class WindowFactory
extends WidgetFactory {
    public WindowFactory(Class beanClass) {
        super(beanClass);
    }

    public Object newInstance(FactoryBuilderSupport builder, Object name, Object value, Map attributes) throws InstantiationException, IllegalAccessException {
        Object parent = builder.getCurrent();
        if (parent == null) {
            parent = new Shell();
        }
        if (!(parent instanceof Shell)) {
            throw new InstantiationException("The parent of a Window must be a Shell");
        }
        Window window = (Window)this.createWidget(parent);
        if (window != null) {
            List location;
            List size;
            Shell shell = (Shell)parent;
            String title = (String)attributes.remove("title");
            if (title != null) {
                window.getShell().setText(title);
            }
            if ((size = (List)attributes.remove("size")) != null) {
                Point point = PointConverter.getInstance().parse(size);
                window.getShell().setSize(point);
            }
            if ((location = (List)attributes.remove("location")) != null) {
                Point point = PointConverter.getInstance().parse(location);
                window.getShell().setLocation(point);
            }
        }
        this.setBeanProperties(window, attributes);
        return window;
    }

    public void onNodeCompleted(FactoryBuilderSupport builder, Object parent, Object node) {
        super.onNodeCompleted(builder, parent, node);
        if (node instanceof ApplicationWindowImpl) {
            ToolBarManager toolBarManager;
            CoolBarManager coolBarManager;
            ApplicationWindowImpl window = (ApplicationWindowImpl)((Object)node);
            MenuManager menuManager = window.getMenuBarManager();
            if (menuManager != null) {
                menuManager.updateAll(true);
            }
            if ((coolBarManager = window.getCoolBarManager()) != null) {
                coolBarManager.update(true);
            }
            if ((toolBarManager = window.getToolBarManager()) != null) {
                toolBarManager.update(true);
            }
        }
    }
}

