/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScroller;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    NSScroller view;
    Scrollable parent;
    int minimum;
    int maximum = 100;
    int thumb = 10;
    int increment = 1;
    int pageIncrement = 10;
    id target;
    int actionSelector;

    ScrollBar() {
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return ScrollBar.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.view);
    }

    boolean getDrawing() {
        return this.parent.getDrawing();
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        NSScroller widget = this.view;
        double value = widget.doubleValue();
        return (int)(0.5 + ((double)(this.maximum - this.thumb - this.minimum) * value + (double)this.minimum));
    }

    public Point getSize() {
        this.checkWidget();
        NSRect rect = this.view.frame();
        return new Point((int)rect.width, (int)rect.height);
    }

    public int getThumb() {
        this.checkWidget();
        return this.thumb;
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x10) == 0;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isDrawing() {
        return this.getDrawing() && this.parent.isDrawing();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void register() {
        super.register();
        this.display.addWidget(this.view, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.view != null) {
            this.view.release();
        }
        this.view = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
    }

    void sendSelection() {
        int value = 0;
        if (this.target != null) {
            this.view.sendAction(this.actionSelector, this.target);
        } else {
            value = this.getSelection();
        }
        Event event = new Event();
        int hitPart = this.view.hitPart();
        switch (hitPart) {
            case 4: {
                value -= this.increment;
                event.detail = 0x1000001;
                break;
            }
            case 1: {
                value -= this.pageIncrement;
                event.detail = 0x1000005;
                break;
            }
            case 5: {
                value += this.increment;
                event.detail = 0x1000002;
                break;
            }
            case 3: {
                value += this.pageIncrement;
                event.detail = 0x1000006;
                break;
            }
            case 2: {
                event.detail = 1;
            }
        }
        if (this.target == null && event.detail != 1) {
            this.setSelection(value);
        }
        this.sendEvent(13, event);
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.increment = value;
    }

    void setClipRegion(float x, float y) {
        NSRect frame = this.view.frame();
        this.parent.setClipRegion(frame.x + x, frame.y + y);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (enabled) {
            if ((this.state & 8) == 0) {
                return;
            }
            this.state &= 0xFFFFFFF7;
        } else {
            if ((this.state & 8) != 0) {
                return;
            }
            this.state |= 8;
        }
        this.enableWidget(enabled);
    }

    void enableWidget(boolean enabled) {
        if (!enabled || (this.state & 8) == 0) {
            this.view.setEnabled(enabled);
        }
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        if (value <= this.minimum) {
            return;
        }
        if (value - this.minimum < this.thumb) {
            this.thumb = value - this.minimum;
        }
        int selection = Math.max(this.minimum, Math.min(this.getSelection(), value - this.thumb));
        this.maximum = value;
        this.updateBar(selection, this.minimum, value, this.thumb);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        if (value >= this.maximum) {
            return;
        }
        if (this.maximum - value < this.thumb) {
            this.thumb = this.maximum - value;
        }
        int selection = Math.min(this.maximum - this.thumb, Math.max(this.getSelection(), value));
        this.minimum = value;
        this.updateBar(selection, value, this.maximum, this.thumb);
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.pageIncrement = value;
    }

    public void setSelection(int value) {
        this.checkWidget();
        this.updateBar(value, this.minimum, this.maximum, this.thumb);
    }

    public void setThumb(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        value = Math.min(value, this.maximum - this.minimum);
        this.updateBar(this.getSelection(), this.minimum, this.maximum, value);
        this.thumb = value;
    }

    public void setValues(int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        this.checkWidget();
        if (minimum < 0) {
            return;
        }
        if (maximum < 0) {
            return;
        }
        if (thumb < 1) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        this.thumb = thumb = Math.min(thumb, maximum - minimum);
        this.maximum = maximum;
        this.minimum = minimum;
        this.increment = increment;
        this.pageIncrement = pageIncrement;
        this.updateBar(selection, minimum, maximum, thumb);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        this.parent.setScrollBarVisible(this, visible);
    }

    void updateBar(int selection, int minimum, int maximum, int thumb) {
        NSScroller widget = this.view;
        selection = Math.max(minimum, Math.min(maximum - thumb, selection));
        int range = maximum - thumb - minimum;
        float fraction = range <= 0 ? 1.0f : (float)(selection - minimum) / (float)range;
        float knob = range <= 0 ? 1.0f : (float)thumb / (float)(maximum - minimum);
        widget.setFloatValue(fraction, knob);
        widget.setEnabled(range > 0);
    }
}

