/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.xpath.function;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;
import org.jdesktop.xpath.function.Abs;
import org.jdesktop.xpath.function.AbstractFunction;
import org.jdesktop.xpath.function.EndsWith;
import org.jdesktop.xpath.function.EqualsIgnoreCase;
import org.jdesktop.xpath.function.EscapeUri;
import org.jdesktop.xpath.function.LowerCase;
import org.jdesktop.xpath.function.Matches;
import org.jdesktop.xpath.function.Replace;
import org.jdesktop.xpath.function.UpperCase;

public class XPathFunctionResolverImpl
implements XPathFunctionResolver,
NamespaceContext {
    private static final String NAMESPACE = "http://swinglabs.org/xpath/fn";
    private static Map<Signature, XPathFunction> functions = new HashMap<Signature, XPathFunction>();
    private static Map<String, String> namespaces = new HashMap<String, String>();

    @Override
    public XPathFunction resolveFunction(QName functionName, int arity) {
        return functions.get(new Signature(functionName, arity));
    }

    public static void installFunction(AbstractFunction function) {
        functions.put(new Signature(new QName(NAMESPACE, function.getName()), function.getArity()), function);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new NullPointerException("Null prefix");
        }
        if ("fn".equals(prefix)) {
            return NAMESPACE;
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        prefix = prefix.intern();
        System.out.println("looking for prefix: " + prefix);
        for (String s : namespaces.keySet()) {
            System.out.println(s);
        }
        if (namespaces.containsKey(prefix)) {
            System.out.println("it contains the key: " + prefix);
            return namespaces.get(prefix);
        }
        return "";
    }

    @Override
    public String getPrefix(String uri) {
        throw new UnsupportedOperationException();
    }

    public Iterator getPrefixes(String uri) {
        throw new UnsupportedOperationException();
    }

    public void addNamespaceMapping(String namespacePrefix, String namespace) {
        namespaces.put(namespacePrefix.intern(), namespace.intern());
    }

    public void removeNamespaceMapping(String namespacePrefix) {
        namespaces.remove(namespacePrefix.intern());
    }

    static {
        XPathFunctionResolverImpl.installFunction(new Abs());
        XPathFunctionResolverImpl.installFunction(new EndsWith());
        XPathFunctionResolverImpl.installFunction(new EscapeUri());
        XPathFunctionResolverImpl.installFunction(new LowerCase());
        XPathFunctionResolverImpl.installFunction(new Matches());
        XPathFunctionResolverImpl.installFunction(new Replace());
        XPathFunctionResolverImpl.installFunction(new UpperCase());
        XPathFunctionResolverImpl.installFunction(new EqualsIgnoreCase());
    }

    private static final class Signature {
        private QName functionName;
        private int arity;

        public Signature(QName functionName, int arity) {
            this.functionName = functionName;
            this.arity = arity;
        }

        public boolean equals(Object o) {
            if (o instanceof Signature) {
                Signature s = (Signature)o;
                return s.arity == this.arity && s.functionName.equals(this.functionName);
            }
            return false;
        }

        public int hashCode() {
            return this.functionName.hashCode() + this.arity;
        }
    }
}

