/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.ws;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.dom.SimpleDocument;
import org.jdesktop.dom.SimpleDocumentBuilder;
import org.jdesktop.http.Header;
import org.jdesktop.http.Method;
import org.jdesktop.http.Request;
import org.jdesktop.http.Response;
import org.jdesktop.ws.AbstractHttpService;
import org.w3c.dom.Document;

public class WebService
extends AbstractBean {
    private String wsdl;
    private String port;
    private String service;
    private String targetNamespace;
    private Map<String, Operation> operations = new HashMap<String, Operation>();

    public final String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        String old = this.port;
        this.port = port;
        this.firePropertyChange("port", old, this.port);
    }

    public final String getService() {
        return this.service;
    }

    public void setService(String service) {
        String old = this.service;
        this.service = service;
        this.firePropertyChange("service", old, this.service);
    }

    public final String getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(String wsdl) {
        String old = this.wsdl;
        this.wsdl = wsdl;
        this.firePropertyChange("wsdl", old, this.wsdl);
    }

    public final String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String ns) {
        String old = this.targetNamespace;
        this.targetNamespace = ns;
        this.firePropertyChange("targetNamespace", old, this.targetNamespace);
    }

    public final Operation[] getOperations() {
        return this.operations.values().toArray(new Operation[0]);
    }

    public final int getOperationCount() {
        return this.operations.size();
    }

    public final Operation getOperation(String name) {
        return this.operations.get(name);
    }

    public void addOperation(Operation op) {
        this.operations.put(op.name, op);
    }

    public static final class Operation
    extends AbstractHttpService {
        private Document requestDom;
        private Document responseDom;
        private String name;
        private WebService svc;

        public Operation(WebService svc, String name) {
            if (svc == null || name == null) {
                throw new IllegalArgumentException("Both the svc and name must be specified");
            }
            this.svc = svc;
            this.name = name;
        }

        public final Document getRequestDocument() {
            return this.requestDom;
        }

        public void setRequestDocument(Document dom) {
            Document old = this.requestDom;
            this.requestDom = dom;
            this.firePropertyChange("requestDocument", old, this.requestDom);
        }

        public final Document getResponseDocument() {
            return this.responseDom;
        }

        private void setResponseDocument(Document dom) {
            Document old = this.responseDom;
            this.responseDom = dom;
            this.firePropertyChange("responseDocument", old, this.responseDom);
        }

        public final String getName() {
            return this.name;
        }

        public final WebService getWebService() {
            return this.svc;
        }

        @Override
        protected SwingWorker createWorker() {
            return new SoapWorker(this);
        }

        @Override
        protected void doSend() {
            super.doSend();
            this.setResponseDocument(null);
        }

        private static final class SoapWorker
        extends SwingWorker<SOAPMessage, SOAPMessage> {
            private Operation op;

            SoapWorker(Operation op) {
                this.op = op;
            }

            @Override
            protected SOAPMessage doInBackground() throws Exception {
                boolean mustParseWSDL = true;
                String namespace = this.op.svc.targetNamespace;
                String portName = this.op.svc.port;
                String serviceName = this.op.svc.service;
                String url = null;
                String soapAction = null;
                if (mustParseWSDL) {
                    SimpleDocument wsdlDom = SimpleDocumentBuilder.simpleParse(new URL(this.op.svc.wsdl));
                    if (namespace == null || "".equals(namespace.trim())) {
                        namespace = wsdlDom.getString("/definitions/@targetNamespace");
                    }
                    if (portName == null || "".equals(portName.trim())) {
                        portName = wsdlDom.getString("/definitions/service/port/@name");
                    }
                    if (serviceName == null || "".equals(serviceName.trim())) {
                        serviceName = wsdlDom.getString("/definitions/service/@name");
                    }
                    url = wsdlDom.getString("/definitions/service[@name='" + serviceName + "']/port/address/@location");
                    soapAction = wsdlDom.getString("/definitions/binding/operation[@name='" + this.op.name + "']/operation/@soapAction");
                }
                MessageFactory mf = MessageFactory.newInstance();
                SOAPMessage msg = mf.createMessage();
                if (this.op.requestDom != null) {
                    msg.getSOAPBody().addDocument(this.op.requestDom);
                }
                Request request = new Request();
                request.setUrl(url);
                request.setMethod(Method.POST);
                request.setHeader("Content-type", "text/xml");
                if (soapAction != null) {
                    request.setHeader("SOAPAction", soapAction);
                }
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                msg.writeTo((OutputStream)bytes);
                request.setBody("<?xml version=\"1.0\"?>" + bytes);
                Response response = this.op.getSession().execute(request);
                MimeHeaders headers = new MimeHeaders();
                for (Header h : response.getHeaders()) {
                    headers.addHeader(h.getName(), h.getValue());
                }
                SOAPMessage rsp = mf.createMessage(headers, response.getBodyAsStream());
                return rsp;
            }

            @Override
            protected void done() {
                if (!this.isCancelled()) {
                    try {
                        SOAPMessage msg = (SOAPMessage)this.get();
                        if (msg.getSOAPBody().hasFault()) {
                            this.op.setResponseDocument(msg.getSOAPBody().getFault().getOwnerDocument());
                        } else {
                            this.op.setResponseDocument(msg.getSOAPBody().extractContentAsDocument());
                        }
                    }
                    catch (CancellationException cancelled) {
                    }
                    catch (ExecutionException e) {
                        this.op.fail(e.getCause());
                    }
                    catch (Exception e) {
                        this.op.fail(e);
                    }
                }
            }
        }
    }
}

