/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.ws;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.http.State;
import org.jdesktop.ws.events.AbortEvent;
import org.jdesktop.ws.events.AbortListener;
import org.jdesktop.ws.events.DoneEvent;
import org.jdesktop.ws.events.DoneListener;
import org.jdesktop.ws.events.FailureEvent;
import org.jdesktop.ws.events.FailureListener;

public abstract class BaseService
extends AbstractBean {
    private LinkedBlockingQueue<Event> events = new LinkedBlockingQueue();
    private AtomicBoolean eventInProgress = new AtomicBoolean(false);
    private State state = State.READY;
    private float progress;
    private EventListenerList listeners = new EventListenerList();

    protected BaseService() {
    }

    public final State getState() {
        return this.state;
    }

    protected void setState(State s) {
        State old = this.state;
        this.state = s;
        this.fireOnEDT("state", (Object)old, (Object)this.state);
        switch (this.state) {
            case READY: 
            case CONNECTING: 
            case SENDING: 
            case RECEIVING: 
            case ABORTED: 
            case FAILED: {
                this.setProgress(-1.0f);
            }
        }
    }

    public final float getProgress() {
        return this.progress;
    }

    protected void setProgress(float p) {
        if (p < -1.0f) {
            p = -1.0f;
        }
        if (p > 1.0f) {
            p = 1.0f;
        }
        float old = this.progress;
        this.progress = p;
        this.fireOnEDT("progress", Float.valueOf(old), Float.valueOf(this.progress));
    }

    public final void send() {
        try {
            this.doSend();
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public final void abort() {
        switch (this.state) {
            case CONNECTING: 
            case SENDING: 
            case RECEIVING: 
            case SENT: {
                this.doAbort();
                this.setState(State.ABORTED);
                this.fireAbort();
            }
        }
    }

    public void fail(Throwable th) {
        switch (this.state) {
            case CONNECTING: 
            case SENDING: 
            case RECEIVING: 
            case SENT: {
                this.setState(State.FAILED);
                this.fireFailure(th);
            }
        }
    }

    protected abstract void doSend() throws Exception;

    protected abstract void doAbort();

    protected final void done() {
        this.setState(State.DONE);
        this.fireDone();
    }

    protected final void fireOnEDT(String prop, Object oldv, Object newv) {
        if (oldv == newv) {
            return;
        }
        if (oldv != null && newv != null && oldv.equals(newv)) {
            return;
        }
        PropertyChangeListener[] pcls = this.getPropertyChangeListeners();
        if (pcls.length == 0) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.firePropertyChange(prop, oldv, newv);
        } else {
            for (PropertyChangeListener pcl : pcls) {
                this.events.add(new Event(pcl, new PropertyChangeEvent((Object)this, prop, oldv, newv)));
            }
            if (this.events.size() > 0 && this.eventInProgress.compareAndSet(false, true)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ArrayList copy = new ArrayList();
                        BaseService.this.events.drainTo(copy);
                        for (Event e : copy) {
                            e.listener.propertyChange(e.event);
                        }
                    }
                });
            }
        }
    }

    public final void addDoneListener(DoneListener listener) {
        this.listeners.add(DoneListener.class, listener);
    }

    public final void removeDoneListener(DoneListener listener) {
        this.listeners.remove(DoneListener.class, listener);
    }

    public void addAbortListener(AbortListener listener) {
        this.listeners.add(AbortListener.class, listener);
    }

    public void removeAbortListener(AbortListener listener) {
        this.listeners.remove(AbortListener.class, listener);
    }

    public void addFailureListener(FailureListener listener) {
        this.listeners.add(FailureListener.class, listener);
    }

    public void removeFailureListener(FailureListener listener) {
        this.listeners.remove(FailureListener.class, listener);
    }

    private void fireDone() {
        if (this.getState() != State.DONE) {
            throw new IllegalStateException("Illegal attempt made to fire a done event when not in the DONE state");
        }
        int count = this.listeners.getListenerCount(DoneListener.class);
        if (count == 0) {
            return;
        }
        final DoneEvent evt = new DoneEvent(this);
        final DoneListener[] all = (DoneListener[])this.listeners.getListeners(DoneListener.class);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < all.length; ++i) {
                    all[i].done(evt);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private void fireAbort() {
        if (this.getState() != State.ABORTED) {
            throw new IllegalStateException("Illegal attempt made to fire a abort event when not in the ABORTED state");
        }
        int count = this.listeners.getListenerCount(AbortListener.class);
        if (count == 0) {
            return;
        }
        final AbortEvent evt = new AbortEvent(this);
        final AbortListener[] all = (AbortListener[])this.listeners.getListeners(AbortListener.class);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < all.length; ++i) {
                    all[i].aborted(evt);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private void fireFailure(Throwable th) {
        if (this.getState() != State.FAILED) {
            throw new IllegalStateException("Illegal attempt made to fire a failure event when not in the FAILED state");
        }
        int count = this.listeners.getListenerCount(FailureListener.class);
        if (count == 0) {
            return;
        }
        final FailureEvent evt = new FailureEvent(this, th);
        final FailureListener[] all = (FailureListener[])this.listeners.getListeners(FailureListener.class);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < all.length; ++i) {
                    all[i].failure(evt);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private static final class Event {
        private PropertyChangeListener listener;
        private PropertyChangeEvent event;

        Event(PropertyChangeListener listener, PropertyChangeEvent event) {
            this.listener = listener;
            this.event = event;
        }
    }
}

