/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.ws;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingWorker;
import org.jdesktop.http.Session;
import org.jdesktop.http.State;
import org.jdesktop.ws.BaseService;

public abstract class AbstractHttpService
extends BaseService {
    private WSSession session = new WSSession();
    private AtomicReference<SwingWorker> workerRef = new AtomicReference();

    protected AbstractHttpService() {
        this.session.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String property = evt.getPropertyName();
                if ("progress".equals(property)) {
                    AbstractHttpService.this.setProgress(((Float)evt.getNewValue()).floatValue());
                } else if ("state".equals(property)) {
                    State state = (State)((Object)evt.getNewValue());
                    switch (state) {
                        case READY: 
                        case CONNECTING: 
                        case SENDING: 
                        case SENT: 
                        case RECEIVING: {
                            AbstractHttpService.this.setState(state);
                            break;
                        }
                    }
                }
            }
        });
    }

    @Override
    protected void setState(State s) {
        this.session.setState(s);
        super.setState(s);
    }

    protected Session getSession() {
        return this.session;
    }

    protected abstract SwingWorker createWorker();

    @Override
    protected void doSend() {
        SwingWorker worker = this.createWorker();
        if (!this.workerRef.compareAndSet(null, worker)) {
            throw new IllegalStateException("Cannot send while request/response in process");
        }
        worker.execute();
    }

    @Override
    protected void doAbort() {
        SwingWorker worker = this.workerRef.get();
        if (this.workerRef.compareAndSet(worker, null)) {
            worker.cancel(true);
        }
    }

    private static final class WSSession
    extends Session {
        private WSSession() {
        }

        @Override
        public void setState(State s) {
            super.setState(s);
        }
    }
}

