/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.ws.yahoo.search.websearch;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jdesktop.swingx.ws.yahoo.search.ResultsArrayList;
import org.jdesktop.swingx.ws.yahoo.search.ResultsList;
import org.jdesktop.swingx.ws.yahoo.search.websearch.YahooWebSearchService;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class YahooRelatedSuggestion
extends YahooWebSearchService {
    private String appId;
    private String query;

    @Override
    protected final String getMethod() {
        return "relatedSuggestion";
    }

    @Override
    protected Map getParameters() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appid", this.appId);
        params.put("query", this.query);
        return params;
    }

    @Override
    protected ResultsList<String> readResults(InputStream in) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser p = factory.newSAXParser();
        Parser pp = new Parser();
        p.parse(in, (DefaultHandler)pp);
        ResultsArrayList<String> results = new ResultsArrayList<String>(this, pp.results.size(), 1);
        for (String s : pp.results) {
            results.add(s);
        }
        return results;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        String old = this.getAppId();
        this.appId = appId;
        this.firePropertyChange("appId", old, this.getAppId());
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        String old = this.getQuery();
        this.query = query;
        this.firePropertyChange("query", old, this.getQuery());
    }

    private static final class Parser
    extends DefaultHandler {
        private StringBuilder buffer;
        private List<String> results = new ArrayList<String>();

        private Parser() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.buffer = new StringBuilder();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            try {
                if ("Result".equals(qName)) {
                    this.results.add(this.buffer.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void characters(char[] chars, int start, int offset) throws SAXException {
            if (this.buffer != null) {
                this.buffer.append(chars, start, offset);
            }
        }
    }
}

