/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.ws.yahoo.search.websearch;

import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jdesktop.swingx.ws.yahoo.search.Country;
import org.jdesktop.swingx.ws.yahoo.search.Format;
import org.jdesktop.swingx.ws.yahoo.search.Language;
import org.jdesktop.swingx.ws.yahoo.search.License;
import org.jdesktop.swingx.ws.yahoo.search.ResultsArrayList;
import org.jdesktop.swingx.ws.yahoo.search.ResultsList;
import org.jdesktop.swingx.ws.yahoo.search.websearch.YahooWebSearchService;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class YahooContextSearch
extends YahooWebSearchService {
    private String appId;
    private String query;
    private String context;
    private Format format;
    private boolean adultOk;
    private boolean similarOk;
    private Language language;
    private Country country;
    private Set<String> sites = new HashSet<String>();
    private License license;

    @Override
    protected final String getMethod() {
        return "contextSearch";
    }

    @Override
    protected final Map getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appid", this.appId);
        params.put("query", this.query);
        if (this.context != null) {
            params.put("context", this.context);
        }
        if (this.format != null) {
            params.put("format", this.format.getCode());
        }
        params.put("adult_ok", this.adultOk ? 1 : 0);
        params.put("similar_ok", this.similarOk ? 1 : 0);
        if (this.language != null) {
            params.put("language", this.language.getCode());
        }
        if (this.country != null) {
            params.put("country", this.country.getCode());
        }
        if (this.sites.size() > 0) {
            StringBuilder buffer = new StringBuilder();
            for (String site : this.sites) {
                if (buffer.length() > 0) {
                    buffer.append("&");
                    buffer.append("site=");
                    buffer.append(site);
                    continue;
                }
                buffer.append(site);
            }
            params.put("site", buffer.toString());
        }
        if (this.license != null) {
            params.put("license", this.license.getCode());
        }
        return params;
    }

    @Override
    protected ResultsList<Result> readResults(InputStream in) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser p = factory.newSAXParser();
        Parser pp = new Parser();
        p.parse(in, (DefaultHandler)pp);
        return pp.results;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        String old = this.getAppId();
        this.appId = appId;
        this.firePropertyChange("appId", old, this.getAppId());
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        String old = this.getQuery();
        this.query = query;
        this.firePropertyChange("query", old, this.getQuery());
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        String old = this.getContext();
        this.context = context;
        this.firePropertyChange("context", old, this.getContext());
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        Format old = this.getFormat();
        this.format = format;
        this.firePropertyChange("format", (Object)old, (Object)this.getFormat());
    }

    public boolean isAdultOk() {
        return this.adultOk;
    }

    public void setAdultOk(boolean adultOk) {
        boolean old = this.isAdultOk();
        this.adultOk = adultOk;
        this.firePropertyChange("adultOk", old, this.isAdultOk());
    }

    public boolean isSimilarOk() {
        return this.similarOk;
    }

    public void setSimilarOk(boolean similarOk) {
        boolean old = this.isSimilarOk();
        this.similarOk = similarOk;
        this.firePropertyChange("similarOk", old, this.isSimilarOk());
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        Language old = this.getLanguage();
        this.language = language;
        this.firePropertyChange("language", (Object)old, (Object)this.getLanguage());
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        Country old = this.getCountry();
        this.country = country;
        this.firePropertyChange("country", (Object)old, (Object)this.getCountry());
    }

    public License getLicense() {
        return this.license;
    }

    public void setLicense(License license) {
        License old = this.getLicense();
        this.license = license;
        this.firePropertyChange("license", (Object)old, (Object)this.getLicense());
    }

    private final class Parser
    extends DefaultHandler {
        private StringBuilder buffer;
        private ResultsList<Result> results = null;
        private Result result;

        private Parser() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("ResultSet".equals(qName)) {
                this.results = new ResultsArrayList<Result>(YahooContextSearch.this, Integer.parseInt(attributes.getValue("totalResultsAvailable")), Integer.parseInt(attributes.getValue("firstResultPosition")));
            } else if ("Result".equals(qName)) {
                this.result = new Result();
                this.results.add(this.result);
            } else {
                this.buffer = new StringBuilder();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            try {
                if ("Title".equals(qName)) {
                    this.result.title = this.buffer.toString();
                    return;
                }
                if ("Summary".equals(qName)) {
                    this.result.summary = this.buffer.toString();
                    return;
                }
                if ("Url".equals(qName)) {
                    this.result.url = new URL(this.buffer.toString());
                    return;
                }
                if ("ClickUrl".equals(qName)) {
                    this.result.clickUrl = new URL(this.buffer.toString());
                    return;
                }
                if ("MimeType".equals(qName)) {
                    this.result.mimeType = this.buffer.toString();
                    return;
                }
                if ("ModificationDate".equals(qName)) {
                    this.result.modDate = new Date(Long.parseLong(this.buffer.toString()));
                    return;
                }
                if (!"Cache".equals(qName)) return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void characters(char[] chars, int start, int offset) throws SAXException {
            this.buffer.append(chars, start, offset);
        }
    }

    public static final class Result {
        private String title;
        private String summary;
        private URL url;
        private URL clickUrl;
        private String mimeType;
        private Date modDate;
        private URL cache;

        public String getTitle() {
            return this.title;
        }

        public String getSummary() {
            return this.summary;
        }

        public URL getUrl() {
            return this.url;
        }

        public URL getClickUrl() {
            return this.clickUrl;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public Date getModDate() {
            return this.modDate == null ? null : new Date(this.modDate.getTime());
        }

        public URL getCache() {
            return this.cache;
        }
    }
}

