/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.ws.yahoo.rss;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jdesktop.swingx.ws.yahoo.rss.YahooRSS;

public class YahooCompanyFinanceNews
extends YahooRSS {
    private Set<String> symbols = new HashSet<String>();
    private Type type = Type.COMPANY;

    public void addSymbol(String symbol) {
        this.symbols.add(symbol.toUpperCase());
    }

    public void removeSymbol(String symbol) {
        this.symbols.remove(symbol.toUpperCase());
    }

    public String[] getSymbols() {
        return this.symbols.toArray(new String[0]);
    }

    public void setSymbols(String ... symbols) {
        this.symbols.clear();
        this.symbols.addAll(Arrays.asList(symbols));
    }

    public void setType(Type type) {
        if (type == null) {
            type = Type.COMPANY;
        }
        Type old = this.getType();
        this.type = type;
        this.firePropertyChange("type", (Object)old, (Object)this.getType());
    }

    public Type getType() {
        return this.type;
    }

    @Override
    protected String getUrlPrefix() {
        return "http://finance.yahoo.com/rss/" + (this.getType() == Type.COMPANY ? "headline" : "industry");
    }

    @Override
    protected Map getParameters() {
        HashMap<String, StringBuffer> map = new HashMap<String, StringBuffer>();
        StringBuffer s = new StringBuffer();
        for (String symbol : this.getSymbols()) {
            if (s.length() > 0) {
                s.append(",");
            }
            s.append(symbol);
        }
        map.put("s", s);
        return map;
    }

    public static enum Type {
        COMPANY,
        INDUSTRY;

    }
}

