/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CacheRequest;
import java.net.CacheResponse;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ResponseCache;
import java.net.URI;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;

public class LocalResponseCache
extends ResponseCache {
    public static final boolean IS_CACHE_DISABLED = true;
    public static final File CHACHE_DIR;

    private LocalResponseCache() {
    }

    public static void installResponseCache() {
    }

    public static File getLocalFile(URI remoteUri) {
        int code = remoteUri.hashCode();
        String fileName = Integer.toString(code >= 0 ? code : -code);
        return new File(CHACHE_DIR, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isUpdateAvailable(URI remoteUri, File localFile) {
        URLConnection conn;
        try {
            conn = remoteUri.toURL().openConnection();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            return false;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
        if (!(conn instanceof HttpURLConnection)) {
            return false;
        }
        long localLastMod = localFile.lastModified();
        long remoteLastMod = 0L;
        HttpURLConnection httpconn = (HttpURLConnection)conn;
        httpconn.setUseCaches(false);
        try {
            httpconn.connect();
            remoteLastMod = httpconn.getLastModified();
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            httpconn.disconnect();
        }
        return remoteLastMod > localLastMod;
    }

    @Override
    public CacheResponse get(URI uri, String rqstMethod, Map<String, List<String>> rqstHeaders) throws IOException {
        File localFile = LocalResponseCache.getLocalFile(uri);
        if (!localFile.exists()) {
            return null;
        }
        if (LocalResponseCache.isUpdateAvailable(uri, localFile)) {
            return null;
        }
        if (!localFile.exists()) {
            return null;
        }
        return new LocalCacheResponse(localFile, rqstHeaders);
    }

    @Override
    public CacheRequest put(URI uri, URLConnection conn) throws IOException {
        if (!(conn instanceof HttpURLConnection) || !((HttpURLConnection)conn).getRequestMethod().equals("GET")) {
            return null;
        }
        File localFile = LocalResponseCache.getLocalFile(uri);
        return new LocalCacheRequest(localFile);
    }

    static {
        System.out.println("[AERITH] Cache disabled");
        CHACHE_DIR = new File(System.getProperty("user.home") + File.separator + ".aerith");
        if (!CHACHE_DIR.exists()) {
            CHACHE_DIR.mkdir();
        }
    }

    private class LocalCacheRequest
    extends CacheRequest {
        private final File localFile;
        private FileOutputStream fos;

        private LocalCacheRequest(File localFile) {
            this.localFile = localFile;
            try {
                this.fos = new FileOutputStream(localFile);
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public OutputStream getBody() throws IOException {
            return this.fos;
        }

        @Override
        public void abort() {
            try {
                this.fos.close();
                this.localFile.delete();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class LocalCacheResponse
    extends CacheResponse {
        private FileInputStream fis;
        private final Map<String, List<String>> headers;

        private LocalCacheResponse(File localFile, Map<String, List<String>> rqstHeaders) {
            try {
                this.fis = new FileInputStream(localFile);
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            this.headers = rqstHeaders;
        }

        @Override
        public Map<String, List<String>> getHeaders() throws IOException {
            return this.headers;
        }

        @Override
        public InputStream getBody() throws IOException {
            return this.fis;
        }
    }
}

