/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.mapviewer.Waypoint;
import org.jdesktop.swingx.mapviewer.WaypointRenderer;

public class DefaultWaypointRenderer
implements WaypointRenderer {
    BufferedImage img = null;

    public DefaultWaypointRenderer() {
        try {
            this.img = ImageIO.read(this.getClass().getResource("resources/standard_waypoint.png"));
        }
        catch (Exception ex) {
            System.out.println("couldn't read standard_waypoint.png");
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    @Override
    public boolean paintWaypoint(Graphics2D g, JXMapViewer map, Waypoint waypoint) {
        if (this.img != null) {
            g.drawImage((Image)this.img, -this.img.getWidth() / 2, -this.img.getHeight(), null);
        } else {
            g.setStroke(new BasicStroke(3.0f));
            g.setColor(Color.BLUE);
            g.drawOval(-10, -10, 20, 20);
            g.setStroke(new BasicStroke(1.0f));
            g.drawLine(-10, 0, 10, 0);
            g.drawLine(0, -10, 0, 10);
        }
        return false;
    }
}

