/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.http.async;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.jdesktop.dom.SimpleDocument;
import org.jdesktop.dom.SimpleDocumentBuilder;
import org.jdesktop.http.Method;
import org.jdesktop.http.async.AsyncHttpRequest;
import org.w3c.dom.NodeList;

public class XmlHttpRequest
extends AsyncHttpRequest {
    private SimpleDocument responseXML;

    public final SimpleDocument getResponseXML() {
        if (this.getReadyState() == AsyncHttpRequest.ReadyState.LOADED) {
            return this.responseXML;
        }
        return null;
    }

    @Override
    protected void reset() {
        this.setResponseXML(null);
        super.reset();
    }

    @Override
    protected void handleResponse(String responseText) throws Exception {
        if (responseText == null) {
            this.setResponseXML(null);
        } else {
            try {
                this.setResponseXML(SimpleDocumentBuilder.simpleParse(responseText));
            }
            catch (Exception e) {
                this.setResponseXML(null);
                throw e;
            }
        }
    }

    private void setResponseXML(SimpleDocument dom) {
        SimpleDocument old = this.responseXML;
        this.responseXML = dom;
        this.firePropertyChange("responseXML", old, this.responseXML);
    }

    public static void main(String[] args) {
        final XmlHttpRequest req = new XmlHttpRequest();
        req.addReadyStateChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == AsyncHttpRequest.ReadyState.LOADED) {
                    SimpleDocument dom = req.getResponseXML();
                    XPath xpath = XPathFactory.newInstance().newXPath();
                    try {
                        XPathExpression exp = xpath.compile("//p");
                        NodeList nodes = (NodeList)exp.evaluate(dom, XPathConstants.NODESET);
                        for (int i = 0; i < nodes.getLength(); ++i) {
                            System.out.println(nodes.item(i).getTextContent());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        try {
            req.open(Method.GET, "http://validator.w3.org/");
            req.send();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

