/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.http;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.http.CookieManager;
import org.jdesktop.http.DefaultSecurityHandler;
import org.jdesktop.http.Header;
import org.jdesktop.http.HighSecurityX509TrustManager;
import org.jdesktop.http.LowSecurityX509TrustManager;
import org.jdesktop.http.MediumSecurityX509TrustManager;
import org.jdesktop.http.Method;
import org.jdesktop.http.Parameter;
import org.jdesktop.http.Request;
import org.jdesktop.http.Response;
import org.jdesktop.http.SecurityHandler;
import org.jdesktop.http.State;
import org.jdesktop.http.StatusCode;

public class Session
extends AbstractBean {
    private SecurityLevel sslSecurity;
    private SecurityHandler handler;
    private State state = State.READY;
    private long totalBytes = -1L;
    private long bytesSoFar = 0L;

    public Session() {
        this(true);
    }

    public Session(boolean installCookieManager) {
        this.setSslSecurityLevel(SecurityLevel.Medium);
        this.setMediumSecurityHandler(new DefaultSecurityHandler());
        if (installCookieManager) {
            CookieManager.install();
        }
    }

    public void setSslSecurityLevel(SecurityLevel level) {
        SecurityLevel old = this.getSslSecurityLevel();
        this.sslSecurity = level;
        this.firePropertyChange("sslSecurityLevel", (Object)old, (Object)this.getSslSecurityLevel());
    }

    public final SecurityLevel getSslSecurityLevel() {
        return this.sslSecurity;
    }

    void setMediumSecurityHandler(SecurityHandler h) {
        SecurityHandler old = this.getMediumSecurityHandler();
        this.handler = h;
        this.firePropertyChange("mediumSecurityHandler", old, this.getMediumSecurityHandler());
    }

    SecurityHandler getMediumSecurityHandler() {
        return this.handler;
    }

    private SSLSocketFactory createSocketFactory(String host) {
        try {
            X509TrustManager tm = null;
            SecurityLevel level = this.getSslSecurityLevel();
            tm = level == SecurityLevel.Low ? new LowSecurityX509TrustManager(null) : (level == SecurityLevel.Medium ? new MediumSecurityX509TrustManager(host, this.getMediumSecurityHandler(), null) : new HighSecurityX509TrustManager(null));
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, new TrustManager[]{tm}, null);
            return context.getSocketFactory();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public final long getTotalBytes() {
        return this.totalBytes;
    }

    private void setTotalBytes(long bytes) {
        long old = this.totalBytes;
        float oldProgress = this.getProgress();
        this.totalBytes = bytes;
        this.firePropertyChange("totalBytes", old, this.totalBytes);
        this.firePropertyChange("progress", Float.valueOf(oldProgress), Float.valueOf(this.getProgress()));
    }

    public final long getBytesSoFar() {
        return this.bytesSoFar;
    }

    private void setBytesSoFar(long bytes) {
        long old = this.bytesSoFar;
        float oldProgress = this.getProgress();
        this.bytesSoFar = bytes;
        this.firePropertyChange("bytesSoFar", old, this.bytesSoFar);
        this.firePropertyChange("progress", Float.valueOf(oldProgress), Float.valueOf(this.getProgress()));
    }

    public final float getProgress() {
        if (this.totalBytes <= 0L) {
            return -1.0f;
        }
        float total = this.totalBytes;
        float num = this.bytesSoFar;
        return num / total;
    }

    public final State getState() {
        return this.state;
    }

    protected void setState(State s) {
        State old = this.state;
        this.state = s;
        this.firePropertyChange("state", (Object)old, (Object)this.state);
    }

    public final Response get(String url) throws Exception {
        return this.execute(Method.GET, url);
    }

    public final Response get(String url, Parameter ... params) throws Exception {
        return this.execute(Method.GET, url, params);
    }

    public final Response post(String url) throws Exception {
        return this.execute(Method.POST, url);
    }

    public final Response post(String url, Parameter ... params) throws Exception {
        return this.execute(Method.POST, url, params);
    }

    public final Response put(String url) throws Exception {
        return this.execute(Method.PUT, url);
    }

    public final Response put(String url, Parameter ... params) throws Exception {
        return this.execute(Method.PUT, url, params);
    }

    public final Response execute(Method method, String url) throws Exception {
        return this.execute(method, url, new Parameter[0]);
    }

    public final Response execute(Method method, String url, Parameter ... params) throws Exception {
        if (method == null) {
            throw new NullPointerException("method cannot be null");
        }
        if (url == null) {
            throw new NullPointerException("url cannot be null");
        }
        Request req = new Request();
        req.setParameters(params);
        req.setMethod(method);
        req.setUrl(url);
        return this.execute(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response execute(Request req) throws Exception {
        try {
            String tmp;
            int index;
            Object values;
            this.setTotalBytes(-1L);
            this.setBytesSoFar(0L);
            this.setState(State.CONNECTING);
            StringBuffer surl = new StringBuffer(req.getUrl());
            if (surl.length() == 0) {
                this.setState(State.FAILED);
                throw new IllegalStateException("Cannot excecute a request that has no URL specified");
            }
            int delim = 63;
            for (Parameter p : req.getParameters()) {
                surl.append((char)delim);
                delim = 38;
                String name = URLEncoder.encode(p.getName(), "UTF-8");
                String value = URLEncoder.encode(p.getValue(), "UTF-8");
                surl.append(name + "=" + value);
            }
            URL url = this.createURL(surl.toString());
            URLConnection conn = url.openConnection();
            if (!(conn instanceof HttpURLConnection)) {
                this.setState(State.FAILED);
                throw new IllegalStateException("Must be an HTTP or HTTPS based URL");
            }
            HttpURLConnection http = (HttpURLConnection)conn;
            http.setRequestMethod(req.getMethod().name());
            http.setInstanceFollowRedirects(req.getFollowRedirects());
            for (Header h : req.getHeaders()) {
                http.setRequestProperty(h.getName(), h.getValue());
            }
            if (http instanceof HttpsURLConnection) {
                HttpsURLConnection https = (HttpsURLConnection)http;
                https.setSSLSocketFactory(this.createSocketFactory(url.getHost()));
            }
            long contentLength = -1L;
            Header contentLengthHeader = req.getHeader("Content-Length");
            if (contentLengthHeader != null) {
                try {
                    contentLength = Long.parseLong(contentLengthHeader.getValue().trim());
                }
                catch (NumberFormatException ex) {
                    contentLength = -1L;
                }
            }
            this.setTotalBytes(contentLength);
            this.setState(State.SENDING);
            OutputStream out = null;
            InputStream body = req.getBody();
            if (body != null) {
                try {
                    http.setDoOutput(true);
                    out = http.getOutputStream();
                    byte[] buffer = new byte[8096];
                    int length = -1;
                    while ((length = body.read(buffer)) != -1) {
                        out.write(buffer, 0, length);
                        this.setBytesSoFar(this.bytesSoFar + (long)length);
                    }
                }
                catch (Exception e) {
                    this.setState(State.FAILED);
                    throw e;
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                    body.close();
                }
            }
            this.setState(State.SENT);
            http.connect();
            this.setBytesSoFar(0L);
            this.setTotalBytes(http.getContentLength());
            this.setState(State.RECEIVING);
            HashSet<Header> headers = new HashSet<Header>();
            Header contentType = null;
            for (Map.Entry<String, List<String>> entry : http.getHeaderFields().entrySet()) {
                String headerKey = entry.getKey();
                String headerValue = http.getHeaderField(headerKey);
                if (headerKey == null) continue;
                values = entry.getValue();
                Header.Element[] elements = new Header.Element[values.size()];
                for (int j = 0; j < elements.length; ++j) {
                    elements[j] = new Header.Element(new Parameter((String)values.get(j), (String)values.get(j)));
                }
                Header h = new Header(headerKey, headerValue, elements);
                headers.add(h);
                if (!"Content-Type".equalsIgnoreCase(headerKey)) continue;
                contentType = h;
            }
            byte[] responseBody = null;
            StatusCode responseCode = StatusCode.INTERNAL_SERVER_ERROR;
            InputStream responseStream = null;
            try {
                responseStream = http.getInputStream();
                responseCode = StatusCode.valueOf(http.getResponseCode());
                String contentEncoding = http.getContentEncoding();
                if ("gzip".equals(contentEncoding)) {
                    responseStream = new GZIPInputStream(responseStream);
                }
                responseBody = this.readFully(responseStream);
            }
            catch (FileNotFoundException e) {
                responseStream = http.getErrorStream();
                responseBody = this.readFully(responseStream);
            }
            catch (HttpRetryException e) {
                this.setState(State.FAILED);
                values = new Response(StatusCode.NOT_FOUND, "HttpRetryException: " + e.getMessage(), null, null, null, req.getUrl());
                return values;
            }
            catch (UnknownHostException e) {
                this.setState(State.FAILED);
                values = new Response(StatusCode.NOT_FOUND, "Unknown host", null, null, null, req.getUrl());
                return values;
            }
            catch (IOException ex) {
                String msg = ex.getMessage();
                if (!msg.contains("Server returned HTTP response code:")) throw ex;
                int startIndex = msg.indexOf("code: ") + 6;
                String s = msg.substring(startIndex, startIndex + 3);
                responseCode = StatusCode.valueOf(Integer.parseInt(s));
                responseStream = http.getErrorStream();
                responseBody = this.readFully(responseStream);
            }
            finally {
                if (responseStream != null) {
                    responseStream.close();
                }
            }
            String foo = "foo";
            URI uri = new URI(req.getUrl());
            URI uu = uri.resolve(new URI(foo));
            String baseUrl = uu.toString().substring(0, uu.toString().length() - foo.length());
            String charset = null;
            if (contentType != null && (index = (tmp = contentType.getValue()).indexOf(";")) >= 0 && (index = tmp.indexOf("=", index + 1)) > 0) {
                charset = contentType.getValue().substring(index + 1);
            }
            Response response = new Response(responseCode, http.getResponseMessage(), responseBody, charset, headers, baseUrl);
            this.setState(State.DONE);
            return response;
        }
        catch (InterruptedException ex) {
            this.setState(State.ABORTED);
            throw ex;
        }
    }

    protected URL createURL(String surl) throws MalformedURLException {
        return new URL(surl.toString());
    }

    private byte[] readFully(InputStream in) throws IOException {
        if (in == null) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(8096);
        byte[] buffer = new byte[8096];
        int length = -1;
        while ((length = in.read(buffer)) != -1) {
            out.write(buffer, 0, length);
            this.setBytesSoFar(this.bytesSoFar + (long)length);
        }
        in.close();
        return out.toByteArray();
    }

    public static enum SecurityLevel {
        Low,
        Medium,
        High;

    }
}

