/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.http;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

class LowSecurityX509TrustManager
implements X509TrustManager {
    private X509TrustManager standardTrustManager = null;
    private static final Logger LOG = Logger.getLogger(LowSecurityX509TrustManager.class.getName());

    public LowSecurityX509TrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(keystore);
        TrustManager[] trustmanagers = factory.getTrustManagers();
        if (trustmanagers.length == 0) {
            throw new NoSuchAlgorithmException("no trust manager found");
        }
        this.standardTrustManager = (X509TrustManager)trustmanagers[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        this.standardTrustManager.checkClientTrusted(certificates, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        if (certificates != null && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Server certificate chain:");
            for (int i = 0; i < certificates.length; ++i) {
                LOG.fine("X509Certificate[" + i + "]=" + certificates[i]);
            }
        }
        if (certificates != null && certificates.length == 1) {
            certificates[0].checkValidity();
        } else {
            this.standardTrustManager.checkServerTrusted(certificates, authType);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }
}

