/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.html.form;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jdesktop.dom.SimpleDocument;
import org.jdesktop.html.form.AbstractForm;
import org.jdesktop.html.form.AbstractRadioInput;
import org.jdesktop.html.form.AbstractSelect;
import org.jdesktop.html.form.FileInput;
import org.jdesktop.html.form.FileParameter;
import org.jdesktop.html.form.Form;
import org.jdesktop.html.form.FormRequest;
import org.jdesktop.html.form.Input;
import org.jdesktop.http.Method;
import org.jdesktop.http.Parameter;
import org.jdesktop.http.Response;
import org.jdesktop.http.Session;
import org.w3c.dom.Node;

public final class Forms {
    private Forms() {
    }

    public static Form getForm(SimpleDocument dom, String baseUrl, String expression) {
        try {
            Node n = dom.getElement(expression);
            if (n != null) {
                final String name = dom.getString("@name", n);
                final String action = dom.getString("@action", n);
                final String method = dom.getString("@method", n);
                HashSet<Input> inputs = new HashSet<Input>();
                HashMap<String, HashSet<String>> radioInputs = new HashMap<String, HashSet<String>>();
                for (Node inputNode : dom.getElements(expression + "//input | " + expression + "//select")) {
                    if ("input".equalsIgnoreCase(inputNode.getNodeName())) {
                        final String inputName = dom.getString("@name", inputNode);
                        final String inputValue = dom.getString("@value", inputNode);
                        String inputType = dom.getString("@type", inputNode);
                        if ("radio".equals(inputType)) {
                            HashSet<String> values = (HashSet<String>)radioInputs.get(inputName);
                            if (values == null) {
                                values = new HashSet<String>();
                                radioInputs.put(inputName, values);
                            }
                            values.add(inputValue);
                            continue;
                        }
                        inputs.add(new Input(){
                            private String value;
                            {
                                this.value = inputValue;
                            }

                            @Override
                            public String getName() {
                                return inputName;
                            }

                            @Override
                            public String getValue() {
                                return this.value;
                            }

                            @Override
                            public void setValue(String value) {
                                this.value = value;
                            }
                        });
                        continue;
                    }
                    String selectName = dom.getString("@name", inputNode);
                    String selected = null;
                    HashSet<String> options = new HashSet<String>();
                    for (Node optionValue : dom.getElements("option/@value", inputNode)) {
                        String optionSelected = dom.getString("@selected", optionValue);
                        if ("selected".equals(optionSelected)) {
                            selected = optionValue.getTextContent();
                        }
                        options.add(optionValue.getTextContent());
                    }
                    AbstractSelect select = new AbstractSelect(selectName, options){};
                    if (selected != null) {
                        select.setValue(selected);
                    }
                    inputs.add(select);
                }
                for (String radName : radioInputs.keySet()) {
                    inputs.add(new AbstractRadioInput(radName, (Set)radioInputs.get(radName)));
                }
                return new AbstractForm(baseUrl, inputs){

                    @Override
                    public String getAction() {
                        return action;
                    }

                    @Override
                    public Method getMethod() {
                        return Method.valueOf(method.toUpperCase());
                    }

                    public String getName() {
                        return name;
                    }
                };
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static Form getFormByName(SimpleDocument dom, String baseUrl, String name) {
        return Forms.getForm(dom, baseUrl, "//form[@name='" + name + "']");
    }

    public static Form getFormByIndex(SimpleDocument dom, String baseUrl, int index) {
        return Forms.getForm(dom, baseUrl, "//form[" + index + "]");
    }

    public static Form getFormById(SimpleDocument dom, String baseUrl, String formId) {
        return Forms.getForm(dom, baseUrl, "//form[@id='" + formId + "']");
    }

    public static Parameter[] getParameters(Form f) {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (Input input : f.getInputs()) {
            if (input.getName() == null || input.getValue() == null) continue;
            params.add(new Parameter(input.getName(), input.getValue()));
        }
        return params.toArray(new Parameter[0]);
    }

    public static Response submit(Form f, Session session) throws Exception {
        String url = f.getAction();
        String baseUrl = f.getBaseUrl();
        if (!Forms.isValidUrl(url) && baseUrl != null) {
            if (url.startsWith("/")) {
                String protocol = baseUrl.substring(0, baseUrl.indexOf("//")) + "//";
                String restUrl = baseUrl.substring(baseUrl.indexOf("//") + 2);
                String newBaseUrl = restUrl.substring(0, restUrl.indexOf("/"));
                url = protocol + newBaseUrl + url;
            } else {
                String s = baseUrl;
                int index = s.indexOf(63);
                if (index > 0) {
                    s = s.substring(0, index);
                    index = s.lastIndexOf("/");
                    url = s.substring(0, index) + "/" + url;
                } else {
                    url = s + "/" + url;
                }
            }
        }
        if (!Forms.isValidUrl(url)) {
            throw new IllegalStateException("The action url: '" + url + "' does not form a valid url, even when combined with the " + "base url '" + baseUrl + "'");
        }
        FormRequest req = new FormRequest();
        req.setMethod(f.getMethod());
        req.setUrl(url);
        for (Input i : f.getInputs()) {
            if (i instanceof FileInput) {
                final FileInput fi = (FileInput)i;
                FileParameter param = new FileParameter(){

                    @Override
                    public InputStream getValueStream() {
                        return fi.getValueStream();
                    }
                };
                param.setName(fi.getName());
                param.setFilename(fi.getFilename());
                param.setValue(fi.getFilename());
                param.setContentType(fi.getContentType());
                req.setFormParameter(param);
                continue;
            }
            Parameter param = new Parameter(i.getName(), i.getValue());
            req.setFormParameter(param);
        }
        return session.execute(req);
    }

    private static boolean isValidUrl(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

