/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.html.form;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.html.form.Encoding;
import org.jdesktop.html.form.Form;
import org.jdesktop.html.form.Forms;
import org.jdesktop.html.form.Input;
import org.jdesktop.http.Parameter;
import org.jdesktop.http.Response;
import org.jdesktop.http.Session;

public abstract class AbstractForm
extends AbstractBean
implements Form {
    private Set<Input> inputs = new HashSet<Input>();
    private String baseUrl;
    private Encoding encoding;

    protected AbstractForm(String baseUrl, Set<Input> inputs) {
        this.baseUrl = baseUrl;
        this.encoding = Encoding.UrlEncoded;
        this.inputs.addAll(inputs);
    }

    protected AbstractForm(String baseUrl, Input ... inputs) {
        this.baseUrl = baseUrl;
        this.encoding = Encoding.UrlEncoded;
        if (inputs != null) {
            this.inputs.addAll(Arrays.asList(inputs));
        }
    }

    protected AbstractForm(String baseUrl, Encoding enc, Input ... inputs) {
        this.baseUrl = baseUrl;
        Encoding encoding = this.encoding = enc == null ? Encoding.UrlEncoded : enc;
        if (inputs != null) {
            this.inputs.addAll(Arrays.asList(inputs));
        }
    }

    @Override
    public Input[] getInputs() {
        return this.inputs.toArray(new Input[0]);
    }

    @Override
    public Input getInput(String name) {
        for (Input i : this.inputs) {
            if (!name.equals(i.getName())) continue;
            return i;
        }
        return null;
    }

    public Parameter[] getInputParameters() {
        return Forms.getParameters(this);
    }

    public Response submit(Session session) throws Exception {
        return Forms.submit(this, session);
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public Encoding getEncoding() {
        return this.encoding;
    }
}

