/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dom;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.jdesktop.dom.SimpleDocument;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SimpleDocumentBuilder
extends DocumentBuilder {
    private static ThreadLocal<SimpleDocumentBuilder> PARSER = new ThreadLocal<SimpleDocumentBuilder>(){

        @Override
        protected SimpleDocumentBuilder initialValue() {
            return new SimpleDocumentBuilder(false);
        }
    };
    private static ThreadLocal<SimpleDocumentBuilder> NS_PARSER = new ThreadLocal<SimpleDocumentBuilder>(){

        @Override
        protected SimpleDocumentBuilder initialValue() {
            return new SimpleDocumentBuilder(true);
        }
    };
    private DocumentBuilder builder;

    public SimpleDocumentBuilder() {
        this(true);
    }

    public SimpleDocumentBuilder(boolean namespaceAware) {
        try {
            DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
            f.setNamespaceAware(namespaceAware);
            this.builder = f.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException("Could not create DOM DocumentBuilder", ex);
        }
    }

    public SimpleDocumentBuilder(DocumentBuilderFactory factory) {
        try {
            this.builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException("Could not create DOM DocumentBuilder", ex);
        }
    }

    public SimpleDocument parseString(String xml) throws SAXException, IOException {
        if (xml == null) {
            throw new IllegalArgumentException("xml cannot be null");
        }
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        return this.parse(in);
    }

    @Override
    public SimpleDocument parse(InputSource is) throws SAXException, IOException {
        return new SimpleDocument(this.builder.parse(is));
    }

    @Override
    public SimpleDocument parse(InputStream is) throws SAXException, IOException {
        return new SimpleDocument(super.parse(is));
    }

    @Override
    public SimpleDocument parse(InputStream is, String systemId) throws SAXException, IOException {
        return new SimpleDocument(super.parse(is, systemId));
    }

    @Override
    public SimpleDocument parse(String uri) throws SAXException, IOException {
        return new SimpleDocument(super.parse(uri));
    }

    @Override
    public SimpleDocument parse(File f) throws SAXException, IOException {
        return new SimpleDocument(super.parse(f));
    }

    @Override
    public boolean isNamespaceAware() {
        return this.builder.isNamespaceAware();
    }

    @Override
    public boolean isValidating() {
        return this.builder.isValidating();
    }

    @Override
    public void setEntityResolver(EntityResolver er) {
        this.builder.setEntityResolver(er);
    }

    @Override
    public void setErrorHandler(ErrorHandler eh) {
        this.builder.setErrorHandler(eh);
    }

    @Override
    public SimpleDocument newDocument() {
        return new SimpleDocument(this.builder.newDocument());
    }

    Document newPlainDocument() {
        return this.builder.newDocument();
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        return this.builder.getDOMImplementation();
    }

    @Override
    public void reset() {
        this.builder.reset();
    }

    @Override
    public Schema getSchema() {
        return this.builder.getSchema();
    }

    @Override
    public boolean isXIncludeAware() {
        return this.builder.isXIncludeAware();
    }

    public static SimpleDocument simpleParse(InputSource is) throws SAXException, IOException {
        return SimpleDocumentBuilder.simpleParse(is, false);
    }

    public static SimpleDocument simpleParse(InputStream in) throws SAXException, IOException {
        return SimpleDocumentBuilder.simpleParse(in, false);
    }

    public static SimpleDocument simpleParse(URL url) throws SAXException, IOException {
        return SimpleDocumentBuilder.simpleParse(url, false);
    }

    public static SimpleDocument simpleParse(String xml) throws SAXException, IOException {
        return SimpleDocumentBuilder.simpleParse(xml, false);
    }

    public static SimpleDocument simpleParse(InputSource is, boolean namespaceAware) throws SAXException, IOException {
        return namespaceAware ? NS_PARSER.get().parse(is) : PARSER.get().parse(is);
    }

    public static SimpleDocument simpleParse(InputStream in, boolean namespaceAware) throws SAXException, IOException {
        return namespaceAware ? NS_PARSER.get().parse(in) : PARSER.get().parse(in);
    }

    public static SimpleDocument simpleParse(URL url, boolean namespaceAware) throws SAXException, IOException {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        InputStream in = url.openStream();
        return SimpleDocumentBuilder.simpleParse(in, namespaceAware);
    }

    public static SimpleDocument simpleParse(String xml, boolean namespaceAware) throws SAXException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        return SimpleDocumentBuilder.simpleParse(in, namespaceAware);
    }
}

