/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dom;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.jdesktop.dom.SimpleDocumentBuilder;
import org.jdesktop.dom.SimpleNodeList;
import org.jdesktop.xpath.XPathUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public class SimpleDocument
implements Document {
    private Document dom;
    private XPath xpath;
    private Map<String, SoftReference<XPathExpression>> cachedExpressions = new HashMap<String, SoftReference<XPathExpression>>();

    public SimpleDocument() {
        this(new SimpleDocumentBuilder().newPlainDocument());
    }

    public SimpleDocument(Document dom) {
        if (dom == null) {
            throw new NullPointerException("DOM Cannot be null");
        }
        this.dom = dom;
    }

    public SimpleDocument(String xml) {
        try {
            this.dom = SimpleDocumentBuilder.simpleParse(xml);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.toXML();
    }

    public String toXML() {
        return XPathUtils.toXML(this.dom);
    }

    public String toXML(Node n) {
        SimpleDocument temp = new SimpleDocument();
        Node nn = n.cloneNode(true);
        temp.adoptNode(nn);
        temp.appendChild(nn);
        return temp.toXML();
    }

    public SimpleNodeList getChildElements(Node node) {
        Node[] nodes = new Node[this.getChildElementCount(node)];
        int index = 0;
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1) continue;
            nodes[index++] = n;
        }
        return new SimpleNodeList(nodes);
    }

    public int getChildElementCount(Node node) {
        int count = 0;
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1) continue;
            ++count;
        }
        return count;
    }

    private XPathExpression compile(String expression) throws XPathExpressionException {
        XPathExpression e;
        SoftReference<XPathExpression> ref = this.cachedExpressions.get(expression);
        XPathExpression xPathExpression = e = ref == null ? null : ref.get();
        if (e == null) {
            this.cachedExpressions.remove(expression);
            e = XPathUtils.compile(expression);
            this.cachedExpressions.put(expression, new SoftReference<XPathExpression>(e));
        }
        return e;
    }

    public SimpleNodeList getElements(String expression) {
        try {
            return XPathUtils.getElements(this.compile(expression), (Node)this.dom);
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public SimpleNodeList getElements(String expression, Node node) {
        try {
            return XPathUtils.getElements(this.compile(expression), node);
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public Node getElement(String expression) {
        try {
            return XPathUtils.getElement(this.compile(expression), (Node)this.dom);
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public Node getElement(String expression, Node node) {
        try {
            return XPathUtils.getElement(this.compile(expression), node);
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String getString(String expression) {
        try {
            return XPathUtils.getString(this.compile(expression), (Node)this.dom);
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String getString(String expression, Node node) {
        try {
            return XPathUtils.getString(this.compile(expression), node);
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public DocumentType getDoctype() {
        return this.dom.getDoctype();
    }

    @Override
    public DOMImplementation getImplementation() {
        return this.dom.getImplementation();
    }

    @Override
    public Element getDocumentElement() {
        return this.dom.getDocumentElement();
    }

    @Override
    public Element createElement(String tagName) throws DOMException {
        return this.dom.createElement(tagName);
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return this.dom.createDocumentFragment();
    }

    @Override
    public Text createTextNode(String data) {
        return this.dom.createTextNode(data);
    }

    @Override
    public Comment createComment(String data) {
        return this.dom.createComment(data);
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        return this.dom.createCDATASection(data);
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return this.dom.createProcessingInstruction(target, data);
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        return this.dom.createAttribute(name);
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        return this.dom.createEntityReference(name);
    }

    @Override
    public SimpleNodeList getElementsByTagName(String tagname) {
        return new SimpleNodeList(this.dom.getElementsByTagName(tagname));
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return this.dom.importNode(importedNode, deep);
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.dom.createElementNS(namespaceURI, qualifiedName);
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.dom.createAttributeNS(namespaceURI, qualifiedName);
    }

    @Override
    public SimpleNodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return new SimpleNodeList(this.dom.getElementsByTagNameNS(namespaceURI, localName));
    }

    @Override
    public Element getElementById(String elementId) {
        return this.dom.getElementById(elementId);
    }

    @Override
    public String getInputEncoding() {
        return this.dom.getInputEncoding();
    }

    @Override
    public String getXmlEncoding() {
        return this.dom.getXmlEncoding();
    }

    @Override
    public boolean getXmlStandalone() {
        return this.dom.getXmlStandalone();
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        this.dom.setXmlStandalone(xmlStandalone);
    }

    @Override
    public String getXmlVersion() {
        return this.dom.getXmlVersion();
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
        this.dom.setXmlVersion(xmlVersion);
    }

    @Override
    public boolean getStrictErrorChecking() {
        return this.dom.getStrictErrorChecking();
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        this.dom.setStrictErrorChecking(strictErrorChecking);
    }

    @Override
    public String getDocumentURI() {
        return this.dom.getDocumentURI();
    }

    @Override
    public void setDocumentURI(String documentURI) {
        this.dom.setDocumentURI(documentURI);
    }

    @Override
    public Node adoptNode(Node source) throws DOMException {
        return this.dom.adoptNode(source);
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return this.dom.getDomConfig();
    }

    @Override
    public void normalizeDocument() {
        this.dom.normalizeDocument();
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        return this.dom.renameNode(n, namespaceURI, qualifiedName);
    }

    @Override
    public String getNodeName() {
        return this.dom.getNodeName();
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.dom.getNodeValue();
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        this.dom.setNodeValue(nodeValue);
    }

    @Override
    public short getNodeType() {
        return this.dom.getNodeType();
    }

    @Override
    public Node getParentNode() {
        return this.dom.getParentNode();
    }

    @Override
    public SimpleNodeList getChildNodes() {
        return new SimpleNodeList(this.dom.getChildNodes());
    }

    @Override
    public Node getFirstChild() {
        return this.dom.getFirstChild();
    }

    @Override
    public Node getLastChild() {
        return this.dom.getLastChild();
    }

    @Override
    public Node getPreviousSibling() {
        return this.dom.getPreviousSibling();
    }

    @Override
    public Node getNextSibling() {
        return this.dom.getNextSibling();
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.dom.getAttributes();
    }

    @Override
    public Document getOwnerDocument() {
        return this.dom.getOwnerDocument();
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return this.dom.insertBefore(newChild, refChild);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return this.dom.replaceChild(newChild, oldChild);
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        return this.dom.removeChild(oldChild);
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        return this.dom.appendChild(newChild);
    }

    @Override
    public boolean hasChildNodes() {
        return this.dom.hasChildNodes();
    }

    @Override
    public Node cloneNode(boolean deep) {
        return this.dom.cloneNode(deep);
    }

    @Override
    public void normalize() {
        this.dom.normalize();
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return this.dom.isSupported(feature, version);
    }

    @Override
    public String getNamespaceURI() {
        return this.dom.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.dom.getPrefix();
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        this.dom.setPrefix(prefix);
    }

    @Override
    public String getLocalName() {
        return this.dom.getLocalName();
    }

    @Override
    public boolean hasAttributes() {
        return this.dom.hasAttributes();
    }

    @Override
    public String getBaseURI() {
        return this.dom.getBaseURI();
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        return this.dom.compareDocumentPosition(other);
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.dom.getTextContent();
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.dom.setTextContent(textContent);
    }

    @Override
    public boolean isSameNode(Node other) {
        return this.dom.isSameNode(other);
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return this.dom.lookupPrefix(namespaceURI);
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return this.dom.isDefaultNamespace(namespaceURI);
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return this.dom.lookupNamespaceURI(prefix);
    }

    @Override
    public boolean isEqualNode(Node arg) {
        return this.dom.isEqualNode(arg);
    }

    @Override
    public Object getFeature(String feature, String version) {
        return this.dom.getFeature(feature, version);
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.dom.setUserData(key, data, handler);
    }

    @Override
    public Object getUserData(String key) {
        return this.dom.getUserData(key);
    }
}

