/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dom;

import java.util.Vector;
import org.apache.html.dom.HTMLDocumentImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.ProcessingInstructionImpl;
import org.apache.xerces.dom.TextImpl;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLDocument;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

class HTMLBuilder
extends DefaultHandler2 {
    protected HTMLDocumentImpl _document;
    protected ElementImpl _current;
    private Locator _locator;
    private boolean _ignoreWhitespace = true;
    private boolean _done = true;
    protected Vector _preRootNodes;

    HTMLBuilder() {
    }

    @Override
    public void startDocument() throws SAXException {
        if (!this._done) {
            throw new SAXException("HTM001 State error: startDocument fired twice on one builder.");
        }
        this._document = null;
        this._done = false;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this._document == null) {
            throw new SAXException("HTM002 State error: document never started or missing document element.");
        }
        if (this._current != null) {
            throw new SAXException("HTM003 State error: document ended before end of document element.");
        }
        this._current = null;
        this._done = true;
    }

    @Override
    public synchronized void startElement(String uri, String localName, String qName, Attributes attrList) throws SAXException {
        int i;
        ElementImpl elem;
        String tagName = this.getName(qName, localName);
        if (tagName == null) {
            throw new SAXException("HTM004 Argument 'tagName' is null.");
        }
        if (this._document == null) {
            this._document = new HTMLDocumentImpl();
            this._current = elem = (ElementImpl)this._document.getDocumentElement();
            if (this._current == null) {
                throw new SAXException("HTM005 State error: Document.getDocumentElement returns null.");
            }
            if (this._preRootNodes != null) {
                i = this._preRootNodes.size();
                while (i-- > 0) {
                    this._document.insertBefore((Node)this._preRootNodes.elementAt(i), (Node)elem);
                }
                this._preRootNodes = null;
            }
        } else {
            if (this._current == null) {
                throw new SAXException("HTM006 State error: startElement called after end of document element.");
            }
            elem = (ElementImpl)this._document.createElement(tagName);
            this._current.appendChild((Node)elem);
            this._current = elem;
        }
        if (attrList != null) {
            for (i = 0; i < attrList.getLength(); ++i) {
                elem.setAttribute(this.getName(attrList.getQName(i), attrList.getLocalName(i)), attrList.getValue(i));
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String tagName = this.getName(qName, localName);
        if (this._current == null) {
            throw new SAXException("HTM007 State error: endElement called with no current node.");
        }
        if (!this._current.getNodeName().equalsIgnoreCase(tagName)) {
            throw new SAXException("HTM008 State error: mismatch in closing tag name " + tagName + "\n" + tagName);
        }
        this._current = this._current.getParentNode() == this._current.getOwnerDocument() ? null : (ElementImpl)this._current.getParentNode();
    }

    @Override
    public void characters(char[] text, int start, int length) throws SAXException {
        if (this._current == null) {
            throw new SAXException("HTM010 State error: character data found outside of root element.");
        }
        this._current.appendChild((Node)new TextImpl((CoreDocumentImpl)this._document, new String(text, start, length)));
    }

    @Override
    public void ignorableWhitespace(char[] text, int start, int length) throws SAXException {
        if (!this._ignoreWhitespace) {
            this._current.appendChild((Node)new TextImpl((CoreDocumentImpl)this._document, new String(text, start, length)));
        }
    }

    @Override
    public void processingInstruction(String target, String instruction) throws SAXException {
        if (this._current == null && this._document == null) {
            if (this._preRootNodes == null) {
                this._preRootNodes = new Vector();
            }
            this._preRootNodes.addElement(new ProcessingInstructionImpl(null, target, instruction));
        } else if (this._current == null && this._document != null) {
            this._document.appendChild((Node)new ProcessingInstructionImpl((CoreDocumentImpl)this._document, target, instruction));
        } else {
            this._current.appendChild((Node)new ProcessingInstructionImpl((CoreDocumentImpl)this._document, target, instruction));
        }
    }

    public HTMLDocument getHTMLDocument() {
        return this._document;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    private String getName(String qName, String localName) {
        return localName == null || "".equals(localName) ? qName : localName;
    }
}

