/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.formatters;

import griffon.core.resources.formatters.AbstractFormatter;
import griffon.core.resources.formatters.ParseException;
import griffon.swing.Colors;
import griffon.util.GriffonNameUtils;
import java.awt.Color;
import java.util.Arrays;
import org.codehaus.groovy.runtime.StringGroovyMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorFormatter
extends AbstractFormatter<Color> {
    public static final String PATTERN_SHORT = "#RGB";
    public static final String PATTERN_SHORT_WITH_ALPHA = "#RGBA";
    public static final String PATTERN_LONG = "#RRGGBB";
    public static final String PATTERN_LONG_WITH_ALPHA = "#RRGGBBAA";
    public static final String DEFAULT_PATTERN = "#RRGGBB";
    private static final String[] PATTERNS = new String[]{"#RRGGBB", "#RRGGBBAA", "#RGB", "#RGBA"};
    public static final ColorFormatter SHORT = new ColorFormatter("#RGB");
    public static final ColorFormatter SHORT_WITH_ALPHA = new ColorFormatter("#RGBA");
    public static final ColorFormatter LONG = new ColorFormatter("#RRGGBB");
    public static final ColorFormatter LONG_WITH_ALPHA = new ColorFormatter("#RRGGBBAA");
    private final ColorFormatterDelegate delegate;

    public static ColorFormatter getInstance(String pattern) {
        return new ColorFormatter(pattern);
    }

    public ColorFormatter() {
        this("#RRGGBB");
    }

    protected ColorFormatter(String pattern) {
        if (PATTERN_SHORT.equals(pattern)) {
            this.delegate = new ShortColorFormatterDelegate();
        } else if (PATTERN_SHORT_WITH_ALPHA.equals(pattern)) {
            this.delegate = new ShortWithAlphaColorFormatterDelegate();
        } else if ("#RRGGBB".equals(pattern)) {
            this.delegate = new LongColorFormatterDelegate();
        } else if (PATTERN_LONG_WITH_ALPHA.equals(pattern)) {
            this.delegate = new LongWithAlphaColorFormatterDelegate();
        } else if (GriffonNameUtils.isBlank((String)pattern)) {
            this.delegate = new LongColorFormatterDelegate();
        } else {
            throw new IllegalArgumentException("Invalid pattern '" + pattern + "'. Valid patterns are " + Arrays.toString(PATTERNS));
        }
    }

    public String format(Color color) {
        return this.delegate.format(color);
    }

    public Color parse(String str) throws ParseException {
        return this.delegate.parse(str);
    }

    public static Color parseColor(String str) throws ParseException {
        if (str.startsWith("#")) {
            switch (str.length()) {
                case 4: {
                    return SHORT.parse(str);
                }
                case 5: {
                    return SHORT_WITH_ALPHA.parse(str);
                }
                case 7: {
                    return LONG.parse(str);
                }
                case 9: {
                    return LONG_WITH_ALPHA.parse(str);
                }
            }
            throw ColorFormatter.parseError((Object)str, Color.class);
        }
        try {
            return Colors.valueOf(str.toUpperCase()).getColor();
        }
        catch (Exception e) {
            throw ColorFormatter.parseError((Object)str, Color.class, (Exception)e);
        }
    }

    private static class LongWithAlphaColorFormatterDelegate
    extends AbstractColorFormatterDelegate {
        private LongWithAlphaColorFormatterDelegate() {
            super(ColorFormatter.PATTERN_LONG_WITH_ALPHA);
        }

        public String format(Color color) {
            if (color == null) {
                throw new IllegalArgumentException("Cannot format given Color because it's null");
            }
            return "#" + StringGroovyMethods.padLeft((String)Integer.toHexString(color.getRed()), (Number)2, (String)"0") + StringGroovyMethods.padLeft((String)Integer.toHexString(color.getGreen()), (Number)2, (String)"0") + StringGroovyMethods.padLeft((String)Integer.toHexString(color.getBlue()), (Number)2, (String)"0") + StringGroovyMethods.padLeft((String)Integer.toHexString(color.getAlpha()), (Number)2, (String)"0");
        }

        public Color parse(String str) throws ParseException {
            if (GriffonNameUtils.isBlank((String)str)) {
                return null;
            }
            if (!str.startsWith("#") || str.length() != 9) {
                throw ColorFormatter.parseError((Object)str, (Class)Color.class);
            }
            int r = ColorFormatter.parseHexInt((String)("" + str.charAt(1) + str.charAt(2)).toUpperCase(), (Class)Color.class);
            int g = ColorFormatter.parseHexInt((String)("" + str.charAt(3) + str.charAt(4)).toUpperCase(), (Class)Color.class);
            int b = ColorFormatter.parseHexInt((String)("" + str.charAt(5) + str.charAt(6)).toUpperCase(), (Class)Color.class);
            int a = ColorFormatter.parseHexInt((String)("" + str.charAt(7) + str.charAt(8)).toUpperCase(), (Class)Color.class);
            return new Color(r, g, b, a);
        }
    }

    private static class LongColorFormatterDelegate
    extends AbstractColorFormatterDelegate {
        private LongColorFormatterDelegate() {
            super("#RRGGBB");
        }

        public String format(Color color) {
            if (color == null) {
                throw new IllegalArgumentException("Cannot format given Color because it's null");
            }
            return "#" + StringGroovyMethods.padLeft((String)Integer.toHexString(color.getRed()), (Number)2, (String)"0") + StringGroovyMethods.padLeft((String)Integer.toHexString(color.getGreen()), (Number)2, (String)"0") + StringGroovyMethods.padLeft((String)Integer.toHexString(color.getBlue()), (Number)2, (String)"0");
        }

        public Color parse(String str) throws ParseException {
            if (GriffonNameUtils.isBlank((String)str)) {
                return null;
            }
            if (!str.startsWith("#") || str.length() != 7) {
                throw ColorFormatter.parseError((Object)str, (Class)Color.class);
            }
            int r = ColorFormatter.parseHexInt((String)("" + str.charAt(1) + str.charAt(2)).toUpperCase(), (Class)Color.class);
            int g = ColorFormatter.parseHexInt((String)("" + str.charAt(3) + str.charAt(4)).toUpperCase(), (Class)Color.class);
            int b = ColorFormatter.parseHexInt((String)("" + str.charAt(5) + str.charAt(6)).toUpperCase(), (Class)Color.class);
            return new Color(r, g, b);
        }
    }

    private static class ShortWithAlphaColorFormatterDelegate
    extends AbstractColorFormatterDelegate {
        private ShortWithAlphaColorFormatterDelegate() {
            super(ColorFormatter.PATTERN_SHORT_WITH_ALPHA);
        }

        public String format(Color color) {
            if (color == null) {
                throw new IllegalArgumentException("Cannot format given Color because it's null");
            }
            return "#" + Integer.toHexString(color.getRed()).charAt(0) + Integer.toHexString(color.getGreen()).charAt(0) + Integer.toHexString(color.getBlue()).charAt(0) + Integer.toHexString(color.getAlpha()).charAt(0);
        }

        public Color parse(String str) throws ParseException {
            if (GriffonNameUtils.isBlank((String)str)) {
                return null;
            }
            if (!str.startsWith("#") || str.length() != 5) {
                throw ColorFormatter.parseError((Object)str, (Class)Color.class);
            }
            int r = ColorFormatter.parseHexInt((String)("" + str.charAt(1) + str.charAt(1)).toUpperCase(), (Class)Color.class);
            int g = ColorFormatter.parseHexInt((String)("" + str.charAt(2) + str.charAt(2)).toUpperCase(), (Class)Color.class);
            int b = ColorFormatter.parseHexInt((String)("" + str.charAt(3) + str.charAt(3)).toUpperCase(), (Class)Color.class);
            int a = ColorFormatter.parseHexInt((String)("" + str.charAt(4) + str.charAt(4)).toUpperCase(), (Class)Color.class);
            return new Color(r, g, b, a);
        }
    }

    private static class ShortColorFormatterDelegate
    extends AbstractColorFormatterDelegate {
        private ShortColorFormatterDelegate() {
            super(ColorFormatter.PATTERN_SHORT);
        }

        public String format(Color color) {
            if (color == null) {
                throw new IllegalArgumentException("Cannot format given Color because it's null");
            }
            return "#" + Integer.toHexString(color.getRed()).charAt(0) + Integer.toHexString(color.getGreen()).charAt(0) + Integer.toHexString(color.getBlue()).charAt(0);
        }

        public Color parse(String str) throws ParseException {
            if (GriffonNameUtils.isBlank((String)str) || !str.startsWith("#") || str.length() != 4) {
                throw ColorFormatter.parseError((Object)str, (Class)Color.class);
            }
            int r = ColorFormatter.parseHexInt((String)("" + str.charAt(1) + str.charAt(1)).toUpperCase(), (Class)Color.class);
            int g = ColorFormatter.parseHexInt((String)("" + str.charAt(2) + str.charAt(2)).toUpperCase(), (Class)Color.class);
            int b = ColorFormatter.parseHexInt((String)("" + str.charAt(3) + str.charAt(3)).toUpperCase(), (Class)Color.class);
            return new Color(r, g, b);
        }
    }

    private static abstract class AbstractColorFormatterDelegate
    implements ColorFormatterDelegate {
        private final String pattern;

        private AbstractColorFormatterDelegate(String pattern) {
            this.pattern = pattern;
        }

        public String getPattern() {
            return this.pattern;
        }
    }

    private static interface ColorFormatterDelegate {
        public String getPattern();

        public String format(Color var1);

        public Color parse(String var1) throws ParseException;
    }
}

