/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Map;

public class Point2DPropertyEditor
extends AbstractPropertyEditor {
    public String getAsText() {
        if (null == this.getValue()) {
            return null;
        }
        Point2D p = (Point2D)this.getValue();
        return p.getX() + ", " + p.getY();
    }

    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof List) {
            this.handleAsList((List)value);
        } else if (value instanceof Map) {
            this.handleAsMap((Map)value);
        } else if (value instanceof Number) {
            this.handleAsNumber((Number)value);
        } else if (value instanceof Point2D) {
            super.setValueInternal(value);
        } else {
            throw this.illegalValue(value, Point2D.class);
        }
    }

    private void handleAsString(String str) {
        String[] parts = str.split(",");
        switch (parts.length) {
            case 1: {
                double s = this.parseValue(parts[0]);
                super.setValueInternal((Object)new Point2D.Double(s, s));
                break;
            }
            case 2: {
                double x = this.parseValue(parts[0]);
                double y = this.parseValue(parts[1]);
                super.setValueInternal((Object)new Point2D.Double(x, y));
                break;
            }
            default: {
                throw this.illegalValue(str, Point2D.class);
            }
        }
    }

    private void handleAsList(List list) {
        switch (list.size()) {
            case 1: {
                double s = this.parseValue(list.get(0));
                super.setValueInternal((Object)new Point2D.Double(s, s));
                break;
            }
            case 2: {
                double x = this.parseValue(list.get(0));
                double y = this.parseValue(list.get(1));
                super.setValueInternal((Object)new Point2D.Double(x, y));
                break;
            }
            default: {
                throw this.illegalValue(list, Point2D.class);
            }
        }
    }

    private void handleAsMap(Map map) {
        double x = this.getMapValue(map, "x", 0);
        double y = this.getMapValue(map, "y", 0);
        super.setValueInternal((Object)new Point2D.Double(x, y));
    }

    private double parseValue(Object value) {
        if (value instanceof CharSequence) {
            return this.parse(String.valueOf(value));
        }
        if (value instanceof Number) {
            return this.parse((Number)value);
        }
        throw this.illegalValue(value, Point2D.class);
    }

    private double parse(String val) {
        try {
            return Double.parseDouble(val.trim());
        }
        catch (NumberFormatException e) {
            throw this.illegalValue(val, Point2D.class, e);
        }
    }

    private double parse(Number val) {
        return val.doubleValue();
    }

    private double getMapValue(Map map, String key, int defaultValue) {
        Object val = map.get(key);
        if (null == val) {
            return defaultValue;
        }
        if (val instanceof CharSequence) {
            return this.parse(String.valueOf(val));
        }
        if (val instanceof Number) {
            return this.parse((Number)val);
        }
        throw this.illegalValue(map, Point2D.class);
    }

    private void handleAsNumber(Number value) {
        double s = this.parse(value);
        super.setValueInternal((Object)new Point2D.Double(s, s));
    }
}

